<?php

namespace App\Http\Controllers\CashManage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ExpensesCategory;
use App\Models\ExpensesSubCategory;
use App\Models\pettyCash;
use App\Models\Expenses;
use App\Models\ToDoList;
use App\Models\startCashRegister;
use App\Models\endCashRegister;

  
class pettyCashController extends Controller
{
    public function addPettyCash()
    {
        $Expenses = Expenses::sum('amount');
        $pettyCash= pettyCash::sum('amount');
        $ToDoList = ToDoList::get();
        return view('Section.PettyCash.adPettyCash',compact('ToDoList','Expenses','pettyCash'));
    }
    public function pettyCashCategory()
    {
        $ToDoList = ToDoList::get();
        return view('Section.Categories.creatCategories',compact('ToDoList'));
    }

    public function pettyCashSubCategory()
    {
        $ToDoList = ToDoList::get();
        $ExpensesCategories = ExpensesCategory::get();
        return view('Section.Categories.creatSubCategories',compact('ExpensesCategories','ToDoList'));
    }

    public function storeCategory(Request $request)
    {
        $data = $request->all();
        
        $ExpensesCategory =  ExpensesCategory::create([
            'expenses_category' => $data['Category'],
            'description' => $data['description'],
            

        ]);
        if($ExpensesCategory){
            return response()->json([
                'status' => 'Success',
                'message' => 'Category created successfully'
            ]);
        }
    }
    public function storeSubCategory(Request $request)
    {
        $data = $request->all();
        // dd($data);
        
        $ExpensesSubCategory =  ExpensesSubCategory::create([
            'expenses_category_id' => $data['Category'],
            'expenses_sub_category' => $data['SubCategory'],
            'description' => $data['description'],

        ]);
        if($ExpensesSubCategory){
            return response()->json([
                'status' => 'Success',
                'message' => 'Category created successfully'
            ]);
        }
    }


    public function listExpensesCategory()
        {
            
         $ExpensesCategory = ExpensesCategory::get();
      
            $response['data'] = $ExpensesCategory;
            return response()->json($response);
    
        }
        public function listExpensesSubCategory()
        {
            
         $ExpensesCategory = ExpensesSubCategory::leftJoin('expenses_categories','expenses_sub_categories.expenses_category_id','=','expenses_categories.id')
         ->select('expenses_sub_categories.*','expenses_categories.expenses_category')->get();
      
            $response['data'] = $ExpensesCategory;
            return response()->json($response);
    
        }

        
    public function storePettyCash(Request $request)
    {
        $data = $request->all();
        // dd($data);
        
        $pettyCash =  pettyCash::create([
            'Title' => $data['title'],
            'date' => $data['date'],
            'time' => $data['time'],
            'amount' => $data['amount'],
            'description' => $data['description'],
            'branch_id' => $data['branch_id'],

        ]);
        if ($request->hasFile('file')) {
            $image = $request->file('file');
            $imageName = time() . rand(1, 9) . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('assets/PettyCash'), $imageName);
    
            // Update the PettyCash record with the image name
            $pettyCash->imag_name = $imageName;
            $pettyCash->save();
        }

        if($pettyCash){
            return response()->json([
                'status' => 'Success',
                'message' => 'Category created successfully'
            ]);
        }
        
    }
    public function topupPettycashList()
        {
            
         $topupPettycashList = pettyCash::get();
      
            $response['data'] = $topupPettycashList;
            return response()->json($response);
    
        }

        public function deletePettycash(Request $request)
        {
            $data = $request->all();
            $id = $data['id'];
            $pettyCash = pettyCash::find($id);
            if (!$pettyCash) {
                return response()->json(['message' => 'Staff member not found'], 404);
            }

            $pettyCash->delete();

            return response()->json(['message' => 'Staff member deleted'], 200);

        
        }

        public function deleteExpensesCategory(Request $request)
        {
            $data = $request->all();
            $id = $data['id'];
            $ExpensesCategory = ExpensesCategory::find($id);
            if (!$ExpensesCategory) {
                return response()->json(['message' => 'Staff member not found'], 404);
            }

            $ExpensesCategory->delete();

            return response()->json(['message' => 'Staff member deleted'], 200);

        
        }

        public function deleteExpenses(Request $request)
        {
            $data = $request->all();
            $id = $data['id'];
            $Expenses = Expenses::find($id);
            if (!$Expenses) {
                return response()->json(['message' => 'Staff member not found'], 404);
            }

            $Expenses->delete();

            return response()->json(['message' => 'Staff member deleted'], 200);

        
        }

         
        
        public function deleteExpensesSubCategory(Request $request)
        {
            $data = $request->all();
            $id = $data['id'];
            $ExpensesSubCategory = ExpensesSubCategory::find($id);
            if (!$ExpensesSubCategory) {
                return response()->json(['message' => 'Staff member not found'], 404);
            }

            $ExpensesSubCategory->delete();

            return response()->json(['message' => 'Staff member deleted'], 200);

        
        }
        


    public function storeEndcashSubmit(Request $request)
    {
        $data = $request->all();

    // Check if an entry with the same date already exists
    $existing = endCashRegister::where('date', $data['endcashRegisterdate'])->first();

    if ($existing) {
        return response()->json([
            'status' => 'error',
            'message' => 'An entry for today\'s date already exists.'
        ], 409); // 409 Conflict
    }

    // Proceed with insert
    $pettyCash = endCashRegister::create([
        'date' => $data['endcashRegisterdate'],
        'time' => $data['endcashRegisterTime'],
        'amount' => $data['endcashRegisterAmount'],
    ]);

    if ($pettyCash) {
        return response()->json([
            'status' => 'success',
            'message' => 'Cash entry created successfully.'
        ]);
    }

    return response()->json([
        'status' => 'error',
        'message' => 'Something went wrong.'
    ], 500);
        
    }
    

    public function storeStartcashRegister(Request $request)
    {
        $data = $request->all();
       
        $existing = startCashRegister::where('date', $data['startcashRegisterdate'])->first();

        if ($existing) {
        return response()->json([
            'status' => 'error',
            'message' => 'An entry for today\'s date already exists.'
        ], 409); // 409 Conflict
        }



        $pettyCash =  startCashRegister::create([
            'date' => $data['startcashRegisterdate'],
            'time' => $data['startcashRegisterTime'],
            'amount' => $data['startcashRegisterAmount'],

        ]);
       

         if ($pettyCash) {
        return response()->json([
            'status' => 'success',
            'message' => 'Cash entry created successfully.'
        ]);
    }

    return response()->json([
        'status' => 'error',
        'message' => 'Something went wrong.'
    ], 500);
        
    }

    
}
