<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\pettyCash;
use App\Models\Expenses;
use App\Models\User;
use App\Models\ToDoList;
use App\Models\Branches;
use Illuminate\Support\Facades\Hash;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    // public function __construct()
    // {
    //     $this->middleware('auth');
    // }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $ToDoList = ToDoList::get();
        $Expenses = Expenses::sum('amount');
        $pettyCash= pettyCash::sum('amount');
        return view('welcome',compact('Expenses','pettyCash','ToDoList'));
    }

    public function branchRegister()
    {   
        $ToDoList = ToDoList::get();
        return view('Section.myBusiness.branch',compact('ToDoList'));
      
    }


    public function userUpdate(Request $request)
{
    $data = $request->all();
    // dd($data);

    $user = User::find($data['id']);

    if (!$user) {
        return response()->json(['message' => 'User not found.'], 404);
    }

    // Basic updates
    $user->branch_id = $data['branch_id'];
    $user->email = $data['email'];
    $user->name = $data['name'];

    // Optional password change
    if (!empty($data['newPassword'])) {
        if (!isset($data['previousPassword']) || !Hash::check($data['previousPassword'], $user->password)) {
            return response()->json(['message' => 'Previous password is incorrect.'], 400);
        }

        if ($data['newPassword'] !== $data['newpassword_confirmation']) {
            return response()->json(['message' => 'New password and confirmation do not match.'], 400);
        }

        // All checks passed, update password
        $user->password = Hash::make($data['newPassword']);
    }

    $user->save();

    return response()->json(['message' => 'User updated successfully.'], 200);
}
    public function userRegister()
    {  
         $ToDoList = ToDoList::get();
        $branches = Branches::get();
        return view('Section.myBusiness.user',compact('branches' ,'ToDoList'));
      
    }

    
    public function userList()
    {
        
     $User = User::leftJoin('branches', 'users.branch_id', '=', 'branches.id')
     ->select('users.*','branches.branch_name')->get();
  
        $response['data'] = $User;
        return response()->json($response);

    }

    public function branchList()
    {
        
     $Branches = Branches::get();
  
        $response['data'] = $Branches;
        return response()->json($response);

    }
    
    public function editStatus(Request $request){
        
        $status = (int)$request->status;
        $userid = (int)$request->userid;
        $user = User::where('id', $userid)->first(); // Replace $userId with the actual user's ID

        if ($user) {
            $user->status = $status;
            $user->save();
    
            // Optionally, you can return a response indicating the update was successful.
            return response()->json(['message' => 'Status updated successfully']);
        } else {
            // Handle the case where the user with the given ID was not found.
            return response()->json(['message' => 'User not found'], 404);
        }
    }

    // 
    public function storeTodo(Request $request)
    {
        $data = $request->all();
        
        $ExpensesCategory =  ToDoList::create([
            'date' => $data['date'],
            'description' => $data['toDo'],
            

        ]);
        if($ExpensesCategory){
            return response()->json([
                'status' => 'Success',
                'message' => 'Category created successfully'
            ]);
        }
    }

    // 

    public function deleteTodo(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $ToDoList = ToDoList::find($id);
        if (!$ToDoList) {
            return response()->json(['message' => 'Staff member not found'], 404);
        }

        $ToDoList->delete();

        return response()->json(['message' => 'Staff member deleted'], 200);

    
    }

}
