<?php

namespace App\Http\Controllers\POS;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\productCategory;
use App\Models\purchaseProductsBadgstock;
use App\Models\productBrandCategory;
use App\Models\product;
use App\Models\purchaseProduct;
use App\Models\people;
use App\Models\sale;
use App\Models\saleProduct;
use App\Models\startCashRegister;
use App\Models\purchaseProductItem;
use App\Models\salesPayment;
use App\Models\Expenses;
use App\Models\saleReturn;
use App\Models\purchasePayment;
use App\Models\Branches;
use Illuminate\Support\Facades\Session;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
class POSController extends Controller
{
    
    public function index()
    {   
        $draftCount = sale::where('sales.sale_type', 'DraftOrder')->count();
         
        $draftSaleProduct = saleProduct::leftJoin('products', 'sale_products.product_id', '=', 'products.id')
        ->leftJoin('sales', 'sale_products.sale_id', '=', 'sales.id')
        ->leftJoin('purchase_products_badgstock', 'sale_products.badgstock_id', '=', 'purchase_products_badgstock.id')
        ->leftJoin('sale_items', 'sale_items.sale_product_id', '=', 'sale_products.id')
        ->leftJoin('purchase_product_items', 'sale_items.item_id', '=', 'purchase_product_items.id')
        ->where('sales.sale_type', 'DraftOrder')
        ->selectRaw("
          CASE 
                WHEN sale_products.type = 'product' THEN (purchase_products_badgstock.quantity -  purchase_products_badgstock.sale_quantity) + sale_products.quantity
                ELSE (sale_items.quantity + purchase_product_items.quantity) 
            END as existing_quantity,
             CASE 
                WHEN sale_products.type = 'product' THEN sale_products.warranty_status 
                ELSE sale_items.warranty_status 
            END as warranty_status,
             CASE 
                WHEN sale_products.type = 'product' THEN sale_products.warranty_period 
                ELSE sale_items.warranty_period 
            END as warranty_period,
            CASE 
            WHEN sale_products.type = 'product' THEN CAST(sale_products.quantity AS SIGNED)
            ELSE CAST(sale_items.quantity AS SIGNED)
        END as quantity,
                CASE 
                WHEN sale_products.type = 'product' THEN products.code 
                ELSE sale_items.imu_number 
            END as code,
            CASE 
                WHEN sale_products.type = 'product' THEN sale_products.price 
                ELSE sale_items.price 
            END as price,
            products.name as product_name,
            sales.date,
            sales.id as saleId,
            products.code as barcode,
            products.id  as productID,
            sale_products.cost,
            sale_products.type,
            sale_products.id as saleProductsId,
            sale_items.item_id as itemId,
            sale_products.badgstock_id,
            sales.sale_reference,
            sales.quantity as totalQuontity, 
            sales.final_total_price, 
            sales.nick_name, 
            sales.received_amount
        ")
        ->get()
        ->unique('saleId'); // <--- This removes duplicates



        $productCategories = productCategory::get();
        $Costomers = People::where('type', 'Costomer')->get();
        $sale = sale::latest()->first();
        return view('Section.POS.pos',compact('productCategories','Costomers','sale','draftSaleProduct' ,'draftCount'));
      
    }


    public function index2()
    {   
        $draftCount = sale::where('sales.sale_type', 'DraftOrder')->count();
         
        $draftSaleProduct = saleProduct::leftJoin('products', 'sale_products.product_id', '=', 'products.id')
        ->leftJoin('sales', 'sale_products.sale_id', '=', 'sales.id')
        ->leftJoin('purchase_products_badgstock', 'sale_products.badgstock_id', '=', 'purchase_products_badgstock.id')
        ->leftJoin('sale_items', 'sale_items.sale_product_id', '=', 'sale_products.id')
        ->leftJoin('purchase_product_items', 'sale_items.item_id', '=', 'purchase_product_items.id')
        ->where('sales.sale_type', 'DraftOrder')
        ->selectRaw("
          CASE 
                WHEN sale_products.type = 'product' THEN (purchase_products_badgstock.quantity -  purchase_products_badgstock.sale_quantity) + sale_products.quantity
                ELSE (sale_items.quantity + purchase_product_items.quantity) 
            END as existing_quantity,
             CASE 
                WHEN sale_products.type = 'product' THEN sale_products.warranty_status 
                ELSE sale_items.warranty_status 
            END as warranty_status,
             CASE 
                WHEN sale_products.type = 'product' THEN sale_products.warranty_period 
                ELSE sale_items.warranty_period 
            END as warranty_period,
            CASE 
            WHEN sale_products.type = 'product' THEN CAST(sale_products.quantity AS SIGNED)
            ELSE CAST(sale_items.quantity AS SIGNED)
        END as quantity,
                CASE 
                WHEN sale_products.type = 'product' THEN products.code 
                ELSE sale_items.imu_number 
            END as code,
            CASE 
                WHEN sale_products.type = 'product' THEN sale_products.price 
                ELSE sale_items.price 
            END as price,
            products.name as product_name,
            sales.date,
            sales.id as saleId,
            products.code as barcode,
            products.id  as productID,
            sale_products.cost,
            sale_products.type,
            sale_products.id as saleProductsId,
            sale_items.item_id as itemId,
            sale_products.badgstock_id,
            sales.sale_reference,
            sales.quantity as totalQuontity, 
            sales.final_total_price, 
            sales.nick_name, 
            sales.received_amount
        ")
        ->get()
        ->unique('saleId'); // <--- This removes duplicates



        $productCategories = productCategory::get();
        $Costomers = People::where('type', 'Costomer')->get();
        $sale = sale::latest()->first();
        return view('Section.POS.pos2',compact('productCategories','Costomers','sale','draftSaleProduct' ,'draftCount'));
      
    }


     public function index3()
    {   
        $draftCount = sale::where('sales.sale_type', 'DraftOrder')->count();

        $branch = Branches::where('id', Session('branch_id'))->first();

    
         
        $draftSaleProduct = saleProduct::leftJoin('products', 'sale_products.product_id', '=', 'products.id')
        ->leftJoin('sales', 'sale_products.sale_id', '=', 'sales.id')
        ->leftJoin('purchase_products_badgstock', 'sale_products.badgstock_id', '=', 'purchase_products_badgstock.id')
        ->leftJoin('sale_items', 'sale_items.sale_product_id', '=', 'sale_products.id')
        ->leftJoin('purchase_product_items', 'sale_items.item_id', '=', 'purchase_product_items.id')
        ->where('sales.sale_type', 'DraftOrder')
        ->selectRaw("
          CASE 
                WHEN sale_products.type = 'product' THEN (purchase_products_badgstock.quantity -  purchase_products_badgstock.sale_quantity) + sale_products.quantity
                ELSE (sale_items.quantity + purchase_product_items.quantity) 
            END as existing_quantity,
             CASE 
                WHEN sale_products.type = 'product' THEN sale_products.warranty_status 
                ELSE sale_items.warranty_status 
            END as warranty_status,
             CASE 
                WHEN sale_products.type = 'product' THEN sale_products.warranty_period 
                ELSE sale_items.warranty_period 
            END as warranty_period,
            CASE 
            WHEN sale_products.type = 'product' THEN CAST(sale_products.quantity AS SIGNED)
            ELSE CAST(sale_items.quantity AS SIGNED)
        END as quantity,
                CASE 
                WHEN sale_products.type = 'product' THEN products.code 
                ELSE sale_items.imu_number 
            END as code,
            CASE 
                WHEN sale_products.type = 'product' THEN sale_products.price 
                ELSE sale_items.price 
            END as price,
            products.name as product_name,
            sales.date,
            sales.id as saleId,
            products.code as barcode,
            products.id  as productID,
            sale_products.cost,
            sale_products.type,
            sale_products.id as saleProductsId,
            sale_items.item_id as itemId,
            sale_products.badgstock_id,
            sales.sale_reference,
            sales.quantity as totalQuontity, 
            sales.final_total_price, 
            sales.nick_name, 
            sales.received_amount
        ")
        ->get()
        ->unique('saleId'); // <--- This removes duplicates


       $startCashRegister = startCashRegister::where('date', Carbon::today()->toDateString())->first();
        $amount = $startCashRegister->amount ?? 0;
       $saleAmount = sale::whereDate('date', Carbon::today())->sum('final_total_price');
       $saleCost = sale::whereDate('date', Carbon::today())->sum('total_cost');
        $productCategories = productCategory::leftJoin('products', 'product_categories.id', '=', 'products.product_category_id')
    ->select('product_categories.id','product_categories.category_name','product_categories.image', DB::raw('SUM(products.quantity) as total_quantity'))
    ->groupBy('product_categories.id','product_categories.category_name','product_categories.image')
    ->get();

        $Costomers = People::where('type', 'Costomer')->get();
        $todayTotalSaleCashPayment = SalesPayment::whereDate('date', Carbon::today())->where('method','cash')->sum('amount');
        $todayTotalSaleCashPayment = SalesPayment::whereDate('date', Carbon::today())->where('method','cash')->sum('amount');
         $todayTotalSaleCardPayment = SalesPayment::whereDate('date', Carbon::today())->where('method','Card Payment')->sum('amount');

        $todayTotalSalechequePayment = SalesPayment::whereDate('date', Carbon::today())->where('method','cheque')->sum('amount');
        $todayTotalSaledepositPayment = SalesPayment::whereDate('date', Carbon::today())->where('method','deposit')->sum('amount');
        
        $todayTotalSalePayment = SalesPayment::whereDate('date', Carbon::today())->sum('amount');
        $cashExpenses = Expenses::whereDate('date', Carbon::today())->where('Payment_method','cash')->sum('amount');
        $Expenses = Expenses::whereDate('date', Carbon::today())->sum('amount');
        $salecashReturn = saleReturn::whereDate('date', Carbon::today())->where('Retun_type','Cash Return')->sum('total_price'); 
        $saleReturn = saleReturn::whereDate('date', Carbon::today())->sum('total_price'); 
        $sale = sale::latest()->first();
        return view('Section.POS.pos3',compact('productCategories','Costomers','sale','draftSaleProduct' 
        ,'Expenses','saleReturn','todayTotalSalechequePayment','branch','todayTotalSaledepositPayment','todayTotalSaleCardPayment','todayTotalSalePayment','amount','draftCount' ,'startCashRegister', 'todayTotalSaleCashPayment','saleAmount','saleCost','cashExpenses','salecashReturn'));
      
    }
   public function getProductBrand(Request $request)
{   
    $data = $request->all();

    $productBrandCategories = productBrandCategory::leftJoin('products', 'product_brand_categories.id', '=', 'products.product_brand_id')
        ->where('product_brand_categories.product_category_id', $data['id'])
        ->select([
            'product_brand_categories.product_brand_name',
            'product_brand_categories.image',
            'products.product_brand_id',
            DB::raw('SUM(products.quantity - products.sale_quantity) as total_quantity')
        ])
        ->groupBy('products.product_brand_id', 'product_brand_categories.product_brand_name', 'product_brand_categories.image')
        ->get();

    // Check if no brand category data found
    if ($productBrandCategories->isEmpty()) {
        $productBrandCategories = product::where('products.product_category_id', $data['id'])
          ->select([
            'products.name as product_brand_name',
            'products.image',
            'products.products_type as type',
            'products.id as product_brand_id',
            'products.price as price',
            'products.code as code',

            'products.quantity  as total_quantity'
        ])->get(); // Fallback to all products
    }

    return response()->json([
        'data' => $productBrandCategories
    ]);
}



public function getProductModel(Request $request)
{   
    $data = $request->all();

// $productBrandCategories = product::where('products.product_brand_id', $data['id'])
// ->get();


$productBrandCategories = product::leftJoin('purchase_products_badgstock', 'purchase_products_badgstock.product_id', '=', 'products.id')
    ->leftJoin('branches', 'purchase_products_badgstock.branches_id', '=', 'branches.id')
    ->where('products.product_brand_id', $data['id'])
    ->select([
        DB::raw('purchase_products_badgstock.quantity - purchase_products_badgstock.sale_quantity AS actual_quantity'),
        'products.name',
        'products.id',
        'products.code',
        'branches.branch_name',
        'products.image',
        'purchase_products_badgstock.id as badgstock_id',
        'purchase_products_badgstock.price',
        'purchase_products_badgstock.branches_id',
        'purchase_products_badgstock.each_cost',
    ])
    ->get();



$response['data'] = $productBrandCategories;
  
// Return the response as JSON
return response()->json($response);

}


public function getProductModelItem(Request $request)
{   
    $data = $request->all();

  $purchaseProductItem = purchaseProductItem::leftJoin('products', 'purchase_product_items.product_id', '=', 'products.id')
    ->leftJoin('purchase_products_badgstock', 'purchase_product_items.products_badgstock_id', '=', 'purchase_products_badgstock.id')
    ->where('purchase_product_items.product_id', $data['id'])
    ->where('purchase_product_items.each_cost', $data['each_cost'])
    ->where('purchase_product_items.products_badgstock_id', $data['badgstock_id'])
        ->where('purchase_product_items.quantity', '>','0')
    ->select(
        'purchase_product_items.*',
        'products.name',
        'purchase_products_badgstock.id as badgstock_id',
        'purchase_products_badgstock.price',
    )
    ->get();



    $response['data'] = $purchaseProductItem;
  
    // Return the response as JSON
    return response()->json($response);
}


public function searchProductItems(Request $request)
    {
        



 $query = $request->get('query');

$productType = \DB::table('products')
    ->where(function ($q) use ($query) {
        $q->where('name', 'like', "%{$query}%")
          ->orWhere('code', 'like', "%{$query}%");
    })->value('products_type');

$suggestions = collect(); // Initialize empty in case no condition matches

// Physical products
if ($productType !== 'Foods & Beverages' && $productType !== 'Services') {




$latestBadgstock = DB::table('purchase_products_badgstock as pb1')
            ->select('pb1.id', 'pb1.product_id')
            ->whereRaw('pb1.id = (SELECT MAX(pb2.id) FROM purchase_products_badgstock pb2 WHERE pb2.product_id = pb1.product_id)')
            ->groupBy('pb1.id', 'pb1.product_id');

        $suggestions = Product::query()
            ->leftJoin('purchase_products', 'products.id', '=', 'purchase_products.product_id')
            ->leftJoin('purchase_product_items', 'purchase_products.purchases_id', '=', 'purchase_product_items.purchases_id')
            ->leftJoin('purchases', 'purchase_products.purchases_id', '=', 'purchases.id')
            ->leftJoinSub($latestBadgstock, 'latest_badg_id', function ($join) {
                $join->on('latest_badg_id.product_id', '=', 'products.id');
            })
            ->leftJoin('purchase_products_badgstock', 'purchase_products_badgstock.id', '=', 'latest_badg_id.id')
            ->where(function ($q) use ($query) {
                $q->where('products.name', 'like', "%{$query}%")
                  ->orWhere('products.code', 'like', "%{$query}%")
                  ->orWhere('purchase_product_items.imu_number', 'like', "%{$query}%");
            })
            ->where(function ($q) {
                $q->where(function ($sub) {
                    $sub->whereNotNull('purchase_product_items.id')
                        ->where('purchase_product_items.quantity', '>', 0)
                        ->whereRaw('purchase_product_items.product_id = products.id');
                })
                ->orWhereNull('purchase_product_items.id');
            })
            ->where(function ($q) {
                $q->whereNull('purchase_products_badgstock.purchases_id')
                  ->orWhere('purchases.status', '!=', 'Pending');
            })
            ->distinct()
            ->select([
                'products.code',
                'products.quantity as product_quantity',
                'purchase_product_items.imu_number',
                'purchase_product_items.each_cost AS items_each_cost',
                'purchase_product_items.id as itemId',
                'purchase_product_items.id as product_items_id',
                'purchase_product_items.quantity',
                'purchase_products_badgstock.quantity as badgstock_quantity',
                'purchase_products_badgstock.each_cost',
                'purchase_products_badgstock.id as badgstock_id',
                'purchase_products_badgstock.sale_quantity as sale_quantity',
                'products.id',
                'purchase_products_badgstock.price',
                'purchase_products_badgstock.branches_id',
                'products.name',
            ])
            ->limit(50)
            ->get()
            ->map(function ($item) {
                $item->type = $item->imu_number ? 'product item' : 'product';
                $item->each_cost = $item->items_each_cost ?: $item->each_cost;
                $item->quantity = $item->quantity ?: ($item->badgstock_quantity - $item->sale_quantity);
                $item->imu_number = $item->imu_number ?: $item->code;
                return $item;
            });

  

} elseif ($productType === 'Services') {
    // Services
    $suggestions = \DB::table('products')
        ->leftJoin('purchase_products_badgstock', 'purchase_products_badgstock.product_id', '=', 'products.id')
        ->where('products.products_type', '=', 'Services')
        ->where(function ($q) use ($query) {
            $q->where('products.name', 'like', "%{$query}%")
              ->orWhere('products.code', 'like', "%{$query}%");
        })
        ->select([
            'products.code',
            'purchase_products_badgstock.quantity as badgstock_quantity',
            'purchase_products_badgstock.each_cost',
            'purchase_products_badgstock.id as badgstock_id',
            'purchase_products_badgstock.sale_quantity as sale_quantity',
            'products.id',
            'products.price',
            'products.name',
            'products.products_type',
        ])
        ->limit(50)
        ->get()
        ->map(function ($item) {
            $item->type = 'Services';
            $item->each_cost = $item->each_cost;
            $item->quantity = $item->badgstock_quantity - $item->sale_quantity;
            $item->imu_number = $item->code;
            return $item;
        });

} elseif ($productType === 'Foods & Beverages') {
    // Foods & Beverages
    $suggestions = \DB::table('products')
        ->leftJoin('purchase_products_badgstock', 'purchase_products_badgstock.product_id', '=', 'products.id')
        ->where('products.products_type', '=', 'Foods & Beverages')
        ->where(function ($q) use ($query) {
            $q->where('products.name', 'like', "%{$query}%")
              ->orWhere('products.code', 'like', "%{$query}%");
        })
        ->select([
            'products.code',
            'purchase_products_badgstock.quantity as badgstock_quantity',
            'purchase_products_badgstock.each_cost',
            'purchase_products_badgstock.id as badgstock_id',
            'purchase_products_badgstock.sale_quantity as sale_quantity',
            'products.id',
            'products.price',
            'products.name',
            'products.products_type',
        ])
        ->limit(50)
        ->get()
        ->map(function ($item) {
            $item->type = 'Foods & Beverages';
            $item->each_cost = $item->each_cost;
            $item->quantity = $item->badgstock_quantity - $item->sale_quantity;
            $item->imu_number = $item->code;
            return $item;
        });
}

// Response
if ($suggestions->isEmpty()) {
    return response()->json([
        'success' => false,
        'message' => 'No products found for the given query.'
    ], 404);
}

return response()->json([
    'success' => true,
    'suggestions' => $suggestions
]);

    }




    public function searchProducts(Request $request)
    {
        // Fetch the query string for product name or code
        $query = $request->get('query');
           
        $suggestions = DB::table('products')
    ->leftJoin('purchase_products', 'products.id', '=', 'purchase_products.product_id')
    ->leftJoin('purchases', 'purchase_products.purchases_id', '=', 'purchases.id')
    ->leftJoin('purchase_products_badgstock', 'purchase_products_badgstock.product_id', '=', 'products.id')
    ->where('products.products_type','=','Products')
    ->where(function ($q) use ($query) {
        $q->where('products.name', 'like', "%{$query}%")
          ->orWhere('products.code', 'like', "%{$query}%");
    })
 
    ->select([
        'products.id',
        'products.name',
        'products.code',
        'products.price',
        'products.products_type',
        'products.quantity as product_quantity',
        'purchase_products_badgstock.each_cost',
        'purchase_products_badgstock.quantity as badgstock_quantity',
        'purchase_products_badgstock.sale_quantity',
        'purchase_products_badgstock.branches_id',
        'purchase_products_badgstock.id as badgstock_id',
    ])
    ->distinct()
    ->limit(20)
    ->get()
    ->map(function ($item) {
        $item->type = 'product';
        $item->each_cost = $item->each_cost ?: 0;
        $item->quantity = $item->badgstock_quantity ? ($item->badgstock_quantity - $item->sale_quantity) : $item->product_quantity;
        $item->imu_number = $item->code;
        return $item;
    });
   
    
        // Check if any suggestions were found
        if ($suggestions->isEmpty()) {
            return response()->json([
                'success' => false,
                'message' => 'No products found for the given query.'
            ], 404);
        }
   
        // Return the suggestions as JSON
        return response()->json([
            'success' => true,
            'suggestions' => $suggestions
        ]);
    }


// public function searchProductItems(Request $request)
// {
//     $query = $request->get('query');

//     // Fetch relevant product IDs first to reduce dataset
//     $productIds = purchaseProduct::leftJoin('products', 'purchase_products.product_id', '=', 'products.id')
//         ->leftJoin('purchase_product_items', 'purchase_products.purchases_id', '=', 'purchase_product_items.purchases_id')
//         ->where(function ($q) use ($query) {
//             $q->where('products.name', 'like', "%{$query}%")
//               ->orWhere('products.code', 'like', "%{$query}%")
//               ->orWhere('purchase_product_items.imu_number', 'like', "%{$query}%");
//         })
//         ->select('products.id') // Ensure 'products.id' is selected
//         ->distinct()
//         ->limit(14)
//         ->pluck('id');
        

//     if ($productIds->isEmpty()) {
//         return response()->json([
//             'success' => false,
//             'message' => 'No products found for the given query.'
//         ], 404);
//     }

//     // Fetch matching products with reduced joins
//     $suggestions = Product::whereIn('products.id', $productIds) // Explicitly specify 'products.id'
//         ->leftJoin('purchase_product_items', 'products.id', '=', 'purchase_product_items.product_id')
//         ->leftJoin('purchase_products_badgstock', 'products.id', '=', 'purchase_products_badgstock.product_id')
//         ->where(function ($query) {
//             $query->where(function ($q) {
//                 $q->whereNotNull('purchase_product_items.id') // Ensure item exists
//                   ->where('purchase_product_items.quantity', '>', 0);
//             })
//             ->orWhereNull('purchase_product_items.id'); // Allow products without itemId
//         })
//         ->select([
//             'products.id',
//             'products.code',
//             'products.name',
//             'products.price',
//             'products.quantity as product_quantity',
//             'purchase_product_items.id as itemId',
//             'purchase_product_items.imu_number',
//             'purchase_product_items.quantity',
//             'purchase_products_badgstock.quantity as badgstock_quantity',
//             'purchase_products_badgstock.sale_quantity as sale_quantity',
//             'purchase_products_badgstock.each_cost',
//             'purchase_products_badgstock.id as badgstock_id'
//         ])
//         ->distinct()
//         ->limit(10)
//         ->get()
//         ->map(function ($item) {
//             $item->type = $item->imu_number ? 'product item' : 'product';
//             // $item->quantity = $item->quantity ?: $item->badgstock_quantity ;
//             $item->quantity = $item->quantity ?: $item->badgstock_quantity - $item->sale_quantity;

//             $item->imu_number = $item->imu_number ?: $item->code;
//             return $item;
//         });

//     return response()->json([
//         'success' => true,
//         'suggestions' => $suggestions
//     ]);
// }

}
