<?php

namespace App\Http\Controllers\Purchase;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\product;
use App\Models\ToDoList;
use App\Models\Branches;
use App\Models\purchase;
use App\Models\people;
use App\Models\returnProduct;
use App\Models\returnProductItem;
use App\Models\purchasePayment;
use App\Models\purchaseGrn;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use App\Models\purchaseProduct;
use App\Models\purchaseProductsBadgstock;
use App\Models\purchaseProductItem;
class PurchaseController extends Controller
{
    public function purchaseProduct()
    {   
        $products = product::get();
        $ToDoList = ToDoList::get();
        $branches = branches::get();
        $purchase = purchase::latest()->first();

        $suppliers = People::where('type', 'Supplier')->get();
        return view('Section.Purchase.purchaseProduct',compact('ToDoList','products' ,'suppliers','purchase','branches'));
      
    }



    
    public function PurchaseData(Request $request)
    {   
        $data = $request->all();
        $id =$data['id'];
       
        $products = product::get();
        $ToDoList = ToDoList::get();
        $branches = branches::get();
        $purchase = purchase::where('id', $id)->first();
        $purchaseType = $purchase->purchases_type;

        $purchaseProducts = purchaseProduct::leftJoin('products','purchase_products.product_id','=','products.id')
        ->leftJoin('product_brand_categories','products.product_brand_id','=','product_brand_categories.id')
        ->where('purchase_products.purchases_id', $id)->select('purchase_products.*','products.name as product_name','product_brand_categories.product_brand_name','products.code as barcode'  )->get();
        
        // dd($purchaseProducts);

        $purchaseProductItem = purchaseProductItem::leftJoin('products','purchase_product_items.product_id','=','products.id')
        ->where('purchases_id', $purchase->id)
        ->select('purchase_product_items.*','products.name as product_name')
        ->get(); 

        
        $totalProdutCost = $purchaseProducts->sum('total_cost');
        $totalProdutQuantity = $purchaseProducts->sum('quantity');

       
        // $suppliers = People::where('type', 'Supplier')->get();
        $suppliers = People::where('id', $purchase->supplier_id)->first();
        // if($purchaseType == 'Add Product'){
        return view('Section.Purchase.PurchaseData.purchaseProductData',compact('ToDoList','purchase' ,'suppliers','branches','purchaseProducts','purchaseType','totalProdutCost','totalProdutQuantity','purchaseProductItem'));
        // }
       
      
    }


    public function editPurchaceProduct(Request $request)
    {   
        $data = $request->all();
        $id =$data['id'];
       

        $ToDoList = ToDoList::get();
        $branches = branches::get();
        $purchase = purchase::where('id', $id)->first();
        $purchaseType = $purchase->purchases_type;

        $products = purchaseProduct::leftJoin('products','purchase_products.product_id','=','products.id')
        ->where('purchase_products.purchases_id', $id)->select('purchase_products.*','products.name as product_name')->first();

        $purchaseProducts = purchaseProduct::leftJoin('products','purchase_products.product_id','=','products.id')
        ->leftJoin('purchases','purchase_products.purchases_id','=','purchases.id')
        ->leftJoin('people','purchases.supplier_id','=','people.id')
        ->leftJoin('product_brand_categories','products.product_brand_id','=','product_brand_categories.id')
        ->where('purchase_products.purchases_id', $id)->select('purchase_products.*','products.name as product_name','product_brand_categories.product_brand_name','people.id as supplier_id')->get();
        
        $purchaseProductItem = purchaseProductItem::leftJoin('products','purchase_product_items.product_id','=','products.id')
        ->where('purchases_id', $purchase->id)
        ->select("purchase_product_items.*", "products.name")->get(); 

        $sumByProductItem  = purchaseProductItem::selectRaw('product_id, SUM(quantity) as total_quantity')
        ->where('purchases_id', $purchase->id)
        ->groupBy('product_id')
        ->get();



        $totalProdutCost = $purchaseProducts->sum('total_cost');
        $totalProdutQuantity = $purchaseProducts->sum('quantity');

        $suppliers = People::where('type', 'Supplier')->get();
        if($purchaseType == 'Add Product'){
            return view('Section.Purchase.PurchaseData.editPurchaceProduct',compact('ToDoList','purchaseProductItem','purchase' ,'suppliers','branches','purchaseProducts','totalProdutCost','totalProdutQuantity'));
        }
        if($purchaseType == 'Add Product By Items'){
            return view('Section.Purchase.PurchaseData.editPurchaceProductItems',compact('ToDoList','purchaseProductItem','purchase' ,'suppliers','branches','purchaseProducts','totalProdutCost','totalProdutQuantity','products','sumByProductItem'));
        }
      
    }
    


     public function purchasegrn(Request $request)
    {   
        $data = $request->all();
        $id =$data['id'];
       

        $ToDoList = ToDoList::get();
        $branches = branches::get();
        $lastGrn = purchaseGrn::orderBy('created_at', 'desc')->first();
        
        $purchase = purchase::where('id', $id)->first();
        $purchaseType = $purchase->purchases_type;

        $products = purchaseProduct::leftJoin('products','purchase_products.product_id','=','products.id')
        ->where('purchase_products.purchases_id', $id)->select('purchase_products.*','products.name as product_name')->first();

        $purchaseProducts = purchaseProduct::leftJoin('products','purchase_products.product_id','=','products.id')
        ->leftJoin('purchases','purchase_products.purchases_id','=','purchases.id')
        ->leftJoin('people','purchases.supplier_id','=','people.id')
        ->leftJoin('product_brand_categories','products.product_brand_id','=','product_brand_categories.id')
        ->where('purchase_products.purchases_id', $id)->select('purchase_products.*','products.name as product_name','product_brand_categories.product_brand_name','people.id as supplier_id' ,'products.code as barcode')->get();
        
        $purchaseProductItem = purchaseProductItem::where('purchases_id', $purchase->id)->get(); 

        $sumByProductItem  = purchaseProductItem::selectRaw('product_id, SUM(quantity) as total_quantity')
    ->where('purchases_id', $purchase->id)
    ->groupBy('product_id')
    ->get();



        $totalProdutCost = $purchaseProducts->sum('total_cost');
        $totalProdutQuantity = $purchaseProducts->sum('quantity');

        $suppliers = People::where('type', 'Supplier')->get();
        if($purchaseType == 'Add Product'){
            return view('Section.Purchase.grnProduct',compact('ToDoList','purchaseProductItem','purchase' ,'suppliers','branches','purchaseProducts','totalProdutCost','totalProdutQuantity','lastGrn'));
        }
        if($purchaseType == 'Add Product By Items'){
            return view('Section.Purchase.grnProductItems',compact('ToDoList','purchaseProductItem','purchase' ,'suppliers','branches','purchaseProducts','totalProdutCost','totalProdutQuantity','products','sumByProductItem','lastGrn'));
        }
      
    }
    

    public function listPurchase()
    {   

        $purchaseTotalSums = purchase::leftJoin('purchase_products', 'purchases.id', '=', 'purchase_products.purchases_id')
        ->select(
        DB::raw('SUM(purchase_products.quantity) as overall_total_quantity'),
        DB::raw('SUM(purchases.total_paid) as overall_total_paid'),
        DB::raw('SUM(purchase_products.total_cost) as overall_total_cost')
    )
    ->first();
        $ToDoList = ToDoList::get();
      return view('Section.Purchase.purchaseList',compact('ToDoList','purchaseTotalSums'));
    }
    
    
    public function purchaseOrder()
    {   

        $purchaseTotalSums = purchase::leftJoin('purchase_products', 'purchases.id', '=', 'purchase_products.purchases_id')
        ->where('purchases.status', 'Pending')
        ->select(
        DB::raw('SUM(purchase_products.quantity) as overall_total_quantity'),
        DB::raw('SUM(purchases.total_paid) as overall_total_paid'),
        DB::raw('SUM(purchase_products.total_cost) as overall_total_cost')
    )
    ->first();
        $ToDoList = ToDoList::get();
      return view('Section.Purchase.purchaseOrder',compact('ToDoList','purchaseTotalSums'));
    }
    
//     public function updatePurchase(Request $request)
//     {
//         $data = $request->all();
//         // dd($data);
//         $branches_id = $data['branch'];
//         $Purchaseid = $data['Purchaseid'];

//         $updatedPurchase = Purchase::where('id', $Purchaseid)->update([
//             'total_cost' => $data['totalCost'],
//             'status' => $data['PurchaseStatus']
//         ]);


//         $mortgageData = isset($data['mortgageData']) ? $data['mortgageData'] : [];
  
//         foreach ($mortgageData as $rowData) {
//             // Retrieve all product items that match the purchases_id and itemDataId (product_id)
//             $productItems = purchaseProduct::where('purchases_id', $Purchaseid)
//                 ->where('product_id', $rowData['itemDataId']) // Match by itemDataId (product_id)
//                 ->get(); // Use get() to retrieve all matching records
            

//             $brandQuantitySum = purchaseProduct::where('product_id', $rowData['itemDataId']) // Match by itemDataId (product_id)
//             ->sum('quantity');

//             $existingQuantitySum = purchaseProduct::where('product_id', $rowData['itemDataId']) // Match by product_id
//                 ->where('each_cost', $rowData['itemCost']) // Match by each_cost
//                 ->sum('quantity');

//             $existingCostSum = purchaseProduct::where('product_id', $rowData['itemDataId']) // Match by product_id
//                 ->where('each_cost', $rowData['itemCost']) // Match by each_cost
//                 ->sum('total_cost');


//                 $purchaseProducts = purchaseProduct::where('product_id', $rowData['itemDataId']) // Match by product_id
//                         ->where('each_cost', $rowData['itemCost']) // Match by each_cost
//                         ->where('purchases_id', $Purchaseid)->get();
//             // Check if records were retrieved
//             if ($productItems->isNotEmpty()) {
//                 foreach ($productItems as $productItem) {

//                     if($data['preStatus']=='Pending'){

                        

//                         foreach ($purchaseProducts as $product) {
//                             // dd($rowData['itemQuantity']);
//                             $product->quantity = $rowData['itemQuantity'];
//                             $product->total_cost = $rowData['totItemCost'];
//                             $product->save();
//                         }

                     
//                     }else{

//                         foreach ($purchaseProducts as $product) {
//                             // dd($rowData['itemQuantity']);
//                             $product->quantity = $rowData['itemQuantity'];
//                             $product->total_cost = $rowData['totItemCost'];
//                             $product->save();
//                         }


//                         $productItem->quantity = $rowData['itemQuantity']; // Update quantity
//                     $productItem->total_cost = $rowData['totItemCost']; // Update total cost
//                     $productItem->each_cost = $rowData['itemCost']; // Update individual cost
                
//                     $productItem->save();

//                     $brandnewQuantitySum = purchaseProduct::where('product_id', $rowData['itemDataId']) // Match by itemDataId (product_id)
//                     ->sum('quantity');

//                     $newQuantitySum = purchaseProduct::where('product_id', $rowData['itemDataId']) // Match by product_id
//                     ->where('each_cost', $rowData['itemCost']) // Match by each_cost
//                     ->sum('quantity');

//                     $newTotalCostSum = purchaseProduct::where('product_id', $rowData['itemDataId']) // Match by product_id
//                     ->where('each_cost', $rowData['itemCost']) // Match by each_cost
//                     ->sum('total_cost');

//                     $QuantityBalance = $newQuantitySum - $existingQuantitySum;
//                     $TotalCostSumBalance = $newTotalCostSum - $existingCostSum;
//                     $brandQuantityBalance =  $brandnewQuantitySum - $brandQuantitySum ; 

//                     // dd($QuantityBalance);


//                     $existingProducts = purchaseProductsBadgstock::where('product_id', $rowData['itemDataId'])
//                     ->where('each_cost', $rowData['itemCost'])->get();

//                     $existingbrands = product::where('id', $rowData['itemDataId'])->get();

//                     if ($existingProducts->isNotEmpty()) {
//                         foreach ($existingProducts as $existingProduct) {
//                             // Check if the cost matches
//                             if ($existingProduct->each_cost == $rowData['itemCost']) {
//                                 // Update the existing row's quantity and total cost
//                                 $existingProduct->quantity += $QuantityBalance;
//                                 $existingProduct->total_cost += $TotalCostSumBalance;
//                                 $existingProduct->save();

                             
//                                 $matched = true; // Mark as matched
//                                 break; // Exit loop once matched
//                             }
                        
                        
                        
//                         }
//                     }
//                     if ($existingbrands->isNotEmpty()) {
//                         foreach ($existingbrands as $existingbrand) {
//                             if ($existingbrand) { // Check if a matching product exists
//                                 $existingbrand->quantity += $brandQuantityBalance;
//                                 $existingbrand->save();
//                             }
//                         }
//                     }
//                     }

                    
                    
//                 }
//             } else {
//                 purchaseProduct::create([
//                     'purchases_id' => $Purchaseid,
//                     'product_id' => $rowData['itemDataId'],
//                     'quantity' => $rowData['itemQuantity'],
//                     'each_cost' => $rowData['itemCost'],
//                     'total_cost' => $rowData['totItemCost'],
//                     'branches_id' => $branches_id,
//                 ]);
                
//             }
//         }




// }

// public function updatePurchase(Request $request)
// {
//     $data = $request->all();
    
//     $branches_id = $data['branch'];
//     $purchaseId = $data['Purchaseid'];

//     DB::beginTransaction();

//     try {
//         // Update the main purchase record
//         Purchase::where('id', $purchaseId)->update([
//             'total_cost' => $data['totalCost'],
//             'status' => $data['PurchaseStatus']
//         ]);

//         $mortgageData = $data['mortgageData'] ?? [];

//         foreach ($mortgageData as $rowData) {
//             $productId = $rowData['itemDataId'];
//             $eachCost = $rowData['itemCost'];
//             $price = $rowData['itemPrice'];
//             $quantity = $rowData['itemQuantity'];
//             $totalCost = $rowData['totItemCost'];

//             // Get all products in this purchase matching this product
//             $purchaseProducts = purchaseProduct::where('product_id', $productId)
//                 ->where('each_cost', $eachCost)
//                  ->where('price', $price)
//                 ->where('purchases_id', $purchaseId)
//                 ->get();

//             // Sum before update
//             $existingQuantitySum = purchaseProduct::where('product_id', $productId)
//                 ->where('each_cost', $eachCost)
//                  ->where('price', $price)
//                 ->sum('quantity');

//             $existingCostSum = purchaseProduct::where('product_id', $productId)
//                 ->where('each_cost', $eachCost)
//                 ->where('price', $price)
//                 ->sum('total_cost');

//             $totalQuantityBefore = purchaseProduct::where('product_id', $productId)->sum('quantity');


            
//             // Update existing purchaseProducts
//             foreach ($purchaseProducts as $product) {
//                 $product->quantity = $quantity;
//                 $product->total_cost = $totalCost;
//                 $product->price = $price;
//                 $product->save();
//             }

//             // If not found, create a new record
//             if ($purchaseProducts->isEmpty()) {
//                 purchaseProduct::create([
//                     'purchases_id' => $purchaseId,
//                     'product_id' => $productId,
//                     'quantity' => $quantity,
//                     'each_cost' => $eachCost,
//                     'price' => $price,
//                     'total_cost' => $totalCost,
//                     'branches_id' => $branches_id,
//                 ]);
//             }

//             // Only proceed with stock updates if previous status wasn't 'Pending'
//             if ($data['preStatus'] == 'Pending' &&  $data['PurchaseStatus'] == 'Received' ) {

               
              
//                 // Update purchaseProductsBadgstock
//                 $existingStock = purchaseProductsBadgstock::where('product_id', $productId)
//                     ->where('each_cost', $eachCost)
//                     ->where('branches_id', $branches_id)
//                      ->where('price', $price)
//                     ->first();

              

//                 if ($existingStock) {
                    
//                     $existingStock->quantity += $quantity;
//                     $existingStock->total_cost += $totalCost;
//                     $existingStock->price += $price;
//                     $existingStock->save();
//                 }else{

//                      purchaseProductsBadgstock::create([
//                             'product_id' => $rowData['itemDataId'],
//                             'purchases_id' => $purchaseId,
//                             'quantity' => $rowData['itemQuantity'],
//                             'branches_id' => $branches_id,
//                             'total_cost' => $rowData['totItemCost'],
//                             'each_cost' => $rowData['itemCost'],
//                             'price' => $rowData['itemPrice'],
//                         ]);
//                 }

//                 // Update product table quantity
//                 $productRecord = product::find($productId);
//                 if ($productRecord) {
//                     $productRecord->quantity += $quantity;
//                     $productRecord->save();
//                 }
               

//                 if ($data['grn_id']) {
//                     $existingGrn = purchaseGrn::where('GRN_reference', $data['grn_id'])->first();

//                 if (!$existingGrn) {
//                     purchaseGrn::create([
//                     'purchases_id' => $purchaseId,
//                     'GRN_reference' => $data['grn_id'],
//                     'received_by' => $data['received_by'],
//                     'date' => $data['dateInput'],
//                 ]);
//                 } else {
//         // Optional: update it instead of throwing an error
//                 $existingGrn->update([
//                 'purchases_id' => $purchaseId,
//                 'received_by' => $data['received_by'],
//                 'date' => $data['dateInput'],
//         ]);
//     }
// }

//             }
//                if ($data['preStatus'] == 'Received' &&  $data['PurchaseStatus'] == 'Received' ) {

               
//                 // Sum after update
//                 $updatedQuantitySum = purchaseProduct::where('product_id', $productId)
//                     ->where('each_cost', $eachCost)
//                     ->where('price', $price)
//                     ->sum('quantity');

//                 $updatedCostSum = purchaseProduct::where('product_id', $productId)
//                     ->where('each_cost', $eachCost)
//                     ->where('price', $price)
//                     ->sum('total_cost');

//                 $totalQuantityAfter = purchaseProduct::where('product_id', $productId)->sum('quantity');

//                 // Calculate deltas
//                 $quantityDelta = $updatedQuantitySum - $existingQuantitySum;
//                 $costDelta = $updatedCostSum - $existingCostSum;
//                 $brandQuantityDelta = $totalQuantityAfter - $totalQuantityBefore;
               
//                 // Update purchaseProductsBadgstock
//                 $existingStock = purchaseProductsBadgstock::where('product_id', $productId)
//                     ->where('each_cost', $eachCost)
//                     ->where('price', $price)
//                     ->first();

                    

//                 if ($existingStock) {
//                     $existingStock->quantity += $quantityDelta;
//                     $existingStock->total_cost += $costDelta;
//                     $existingStock->save();
//                 }else{
//                     purchaseProductsBadgstock::create([
//                             'product_id' => $rowData['itemDataId'],
//                             'purchases_id' => $purchaseId,
//                             'quantity' => $rowData['itemQuantity'],
//                             'branches_id' => $branches_id,
//                             'total_cost' => $rowData['totItemCost'],
//                             'each_cost' => $rowData['itemCost'],
//                             'price' => $rowData['itemPrice'],
//                         ]);
//                 }

//                 // Update product table quantity
//                 $productRecord = product::find($productId);
//                 if ($productRecord) {
//                     $productRecord->quantity += $brandQuantityDelta;
//                     $productRecord->save();
//                 }
//             }
//         }

//         DB::commit();
//         return response()->json(['message' => 'Purchase updated successfully'], 200);

//     } catch (\Exception $e) {
//         DB::rollBack();
//         return response()->json([
//             'message' => 'Error updating purchase',
//             'error' => $e->getMessage()
//         ], 500);
//     }
// }
public function updatePurchase(Request $request)
{
    $data = $request->all();

    $branches_id = $data['branch'];
    $purchaseId = $data['Purchaseid'];

    DB::beginTransaction();

    try {
        // Update the main purchase record
        Purchase::where('id', $purchaseId)->update([
            'total_cost' => $data['totalCost'],
            'status' => $data['PurchaseStatus']
        ]);

        $mortgageData = $data['mortgageData'] ?? [];

        foreach ($mortgageData as $rowData) {
            $productId = $rowData['itemDataId'];
            $eachCost = $rowData['itemCost'];
            $price = $rowData['itemPrice'];
            $quantity = $rowData['itemQuantity'];
            $totalCost = $rowData['totItemCost'];

            // Find an existing row that either:
            // 1. Matches product_id, purchases_id, and has cost/price zero
            // 2. Matches exact cost and price
            $purchaseProducts = purchaseProduct::where('product_id', $productId)
                ->where('purchases_id', $purchaseId)
                ->where(function ($q) use ($eachCost, $price) {
                    $q->where(function ($q2) {
                        $q2->where('each_cost', 0)
                           ->where('price', 0)
                           ->where('total_cost', 0);
                    })->orWhere(function ($q2) use ($eachCost, $price) {
                        $q2->where('each_cost', $eachCost)
                           ->where('price', $price);
                    });
                })
                ->get();

            $existingQuantitySum = purchaseProduct::where('product_id', $productId)
                ->where('each_cost', $eachCost)
                ->where('price', $price)
                ->sum('quantity');

            $existingCostSum = purchaseProduct::where('product_id', $productId)
                ->where('each_cost', $eachCost)
                ->where('price', $price)
                ->sum('total_cost');

            $totalQuantityBefore = purchaseProduct::where('product_id', $productId)->sum('quantity');

            if ($purchaseProducts->isNotEmpty()) {
                // Update matching record(s)
                foreach ($purchaseProducts as $product) {
                    $product->quantity = $quantity;
                    $product->each_cost = $eachCost;
                    $product->price = $price;
                    $product->total_cost = $totalCost;
                    $product->save();
                }
            } else {
                // Create new purchase product record
                purchaseProduct::create([
                    'purchases_id' => $purchaseId,
                    'product_id' => $productId,
                    'quantity' => $quantity,
                    'each_cost' => $eachCost,
                    'price' => $price,
                    'total_cost' => $totalCost,
                    'branches_id' => $branches_id,
                ]);
            }

            // Handle stock updates when moving from Pending -> Received
            if ($data['preStatus'] == 'Pending' && $data['PurchaseStatus'] == 'Received') {
                $existingStock = purchaseProductsBadgstock::where('product_id', $productId)
                    ->where('each_cost', $eachCost)
                    ->where('price', $price)
                    ->where('branches_id', $branches_id)
                    ->first();

                if ($existingStock) {
                    $existingStock->quantity += $quantity;
                    $existingStock->total_cost += $totalCost;
                    $existingStock->save();
                } else {
                    purchaseProductsBadgstock::create([
                        'product_id' => $productId,
                        'purchases_id' => $purchaseId,
                        'quantity' => $quantity,
                        'branches_id' => $branches_id,
                        'total_cost' => $totalCost,
                        'each_cost' => $eachCost,
                        'price' => $price,
                    ]);
                }

                // Update product table
                $productRecord = product::find($productId);
                if ($productRecord) {
                    $productRecord->quantity += $quantity;
                    $productRecord->save();
                }

                // Handle GRN creation or update
                if ($data['grn_id']) {
                    $existingGrn = purchaseGrn::where('GRN_reference', $data['grn_id'])->first();
                    if (!$existingGrn) {
                        purchaseGrn::create([
                            'purchases_id' => $purchaseId,
                            'GRN_reference' => $data['grn_id'],
                            'received_by' => $data['received_by'],
                            'date' => $data['dateInput'],
                        ]);
                    } else {
                        $existingGrn->update([
                            'purchases_id' => $purchaseId,
                            'received_by' => $data['received_by'],
                            'date' => $data['dateInput'],
                        ]);
                    }
                }
            }

            // Handle Received -> Received updates
            if ($data['preStatus'] == 'Received' && $data['PurchaseStatus'] == 'Received') {
                $updatedQuantitySum = purchaseProduct::where('product_id', $productId)
                    ->where('each_cost', $eachCost)
                    ->where('price', $price)
                    ->sum('quantity');

                $updatedCostSum = purchaseProduct::where('product_id', $productId)
                    ->where('each_cost', $eachCost)
                    ->where('price', $price)
                    ->sum('total_cost');

                $totalQuantityAfter = purchaseProduct::where('product_id', $productId)->sum('quantity');

                $quantityDelta = $updatedQuantitySum - $existingQuantitySum;
                $costDelta = $updatedCostSum - $existingCostSum;
                $brandQuantityDelta = $totalQuantityAfter - $totalQuantityBefore;

                $existingStock = purchaseProductsBadgstock::where('product_id', $productId)
                    ->where('each_cost', $eachCost)
                    ->where('price', $price)
                    ->first();

                if ($existingStock) {
                    $existingStock->quantity += $quantityDelta;
                    $existingStock->total_cost += $costDelta;
                    $existingStock->save();
                } else {
                    purchaseProductsBadgstock::create([
                        'product_id' => $productId,
                        'purchases_id' => $purchaseId,
                        'quantity' => $quantity,
                        'branches_id' => $branches_id,
                        'total_cost' => $totalCost,
                        'each_cost' => $eachCost,
                        'price' => $price,
                    ]);
                }

                $productRecord = product::find($productId);
                if ($productRecord) {
                    $productRecord->quantity += $brandQuantityDelta;
                    $productRecord->save();
                }
            }
        }

        DB::commit();
        return response()->json(['message' => 'Purchase updated successfully'], 200);

    } catch (\Exception $e) {
        DB::rollBack();
        return response()->json([
            'message' => 'Error updating purchase',
            'error' => $e->getMessage()
        ], 500);
    }
}


// public function updatePurchaseItem(Request $request)
// {
//     $data = $request->all();

//     dd($data );

//     $branches_id = $data['branch'];
//     $Purchaseid = $data['Purchaseid'];
//     $mortgageData = $data['mortgageData'] ?? [];

//     // Step 1: Update total cost of the purchase
//     Purchase::where('id', $Purchaseid)->update([
//         'total_cost' => $data['totalCost']
//     ]);

//     $totalGrouped = [];

//     // Step 2: Group mortgageData by itemDataId and itemCost
//     foreach ($mortgageData as $item) {
//         $itemDataId = $item['itemDataId'];
//         $quantity = (int)$item['itemQuantity'];
//         $cost = (float)$item['itemCost'];
//         $totalCost = (float)$item['totItemCost'];
//         $itemBarcode = $item['itemBarcode'];

//         $compositeKey = $itemDataId . '|' . number_format($cost, 2, '.', '');

//         if (!isset($totalGrouped[$compositeKey])) {
//             $totalGrouped[$compositeKey] = [
//                 'itemDataId' => $itemDataId,
//                 'itemCost' => $cost,
//                 'quantity' => 0,
//                 'totalCost' => 0.0,
//                 'itemBarcode' => $itemBarcode
//             ];
//         }

//         $totalGrouped[$compositeKey]['quantity'] += $quantity;
//         $totalGrouped[$compositeKey]['totalCost'] += $totalCost;
//     }

//     // Step 3: Get existing grouped totals from DB
//     $dbTotals = purchaseProduct::selectRaw('product_id, each_cost, SUM(quantity) as totalQuantity, SUM(total_cost) as totalCost')
//         ->where('purchases_id', $Purchaseid)
//         ->groupBy('product_id', 'each_cost')
//         ->get()
//         ->mapWithKeys(function ($item) {
//             $formattedCost = number_format($item->each_cost, 2, '.', '');
//             return [$item->product_id . '|' . $formattedCost => $item];
//         });

//     // Step 4: Sync purchaseProductsBadgstock and purchaseProduct tables
//     foreach ($totalGrouped as $key => $group) {
//         $productId = $group['itemDataId'];
//         $eachCost = $group['itemCost'];
//         $formQty = $group['quantity'];
//         $formCost = $group['totalCost'];

//         // Update or create in purchaseProductsBadgstock
//         $existingProducts = purchaseProductsBadgstock::where('product_id', $productId)
//             ->where('branches_id', $branches_id)
//             ->where('each_cost', $eachCost)
//             ->first();

//         $existingItemQuantity = purchaseProductItem::where('product_id', $productId)
//             ->where('purchases_id', $Purchaseid)
//             ->where('each_cost', $eachCost)
//             ->sum('quantity');

//         if ($existingProducts) {
//             $actualQuantity = ($existingProducts->quantity - $existingItemQuantity) + $formQty;

//             // dd($actualQuantity);
  
//         //    $existingProducts->update([
//         //     'quantity' => $existingProducts->quantity + $actualQuantity
//         //     ]);


//             $existingProducts->update([
//                 'quantity' => $actualQuantity
//             ]);

//             $productsBadgstockId = $existingProducts->id;
//         } else {
//             $newBadgstock = purchaseProductsBadgstock::create([
//                 'product_id' => $productId,
//                 'purchases_id' => $Purchaseid,
//                 'quantity' => $formQty,
//                 'total_cost' => $formCost,
//                 'each_cost' => $eachCost,
//                 'branches_id' => $branches_id,
//             ]);
//             $productsBadgstockId = $newBadgstock->id;
//         }

//         // Compare and update purchaseProduct
//         $dbQty = isset($dbTotals[$key]) ? (int)$dbTotals[$key]->totalQuantity : 0;
//         $dbCost = isset($dbTotals[$key]) ? (float)$dbTotals[$key]->totalCost : 0.0;

//         $quantityDiff = $formQty - $dbQty;
//         $costDiff = $formCost - $dbCost;

//         if ($quantityDiff != 0 || $costDiff != 0.0) {
//             $existingProduct = purchaseProduct::where('product_id', $productId)
//                 ->where('each_cost', $eachCost)
//                 ->where('purchases_id', $Purchaseid)
//                 ->first();

//             if ($existingProduct) {
//                 $existingProduct->update([
//                     'quantity' => DB::raw("quantity + {$quantityDiff}"),
//                     'total_cost' => DB::raw("total_cost + {$costDiff}")
//                 ]);
//             } else {
//                 purchaseProduct::create([
//                     'purchases_id' => $Purchaseid,
//                     'product_id' => $productId,
//                     'quantity' => $formQty,
//                     'each_cost' => $eachCost,
//                     'total_cost' => $formCost,
//                     'branches_id' => $branches_id,
//                 ]);
//             }
//         }
//     }

//     // Step 5: Update or insert into purchaseProductItem
//     foreach ($mortgageData as $item) {
//         $barcode = $item['itemBarcode'];
//         $productId = $item['itemDataId'];
//         $eachCost = $item['itemCost'];
//         $quantity = $item['itemQuantity'];

//         $existingItem = purchaseProductItem::where('imu_number', $barcode)
//             ->where('product_id', $productId)
//             ->where('purchases_id', $Purchaseid)
//             ->first();

//         $existingItemQuantity = purchaseProductItem::where('imu_number', $barcode)
//             ->where('product_id', $productId)
//             ->where('purchases_id', $Purchaseid)
//             ->sum('quantity');

//         $existingItemCost = purchaseProductItem::where('imu_number', $barcode)
//             ->where('product_id', $productId)
//             ->where('purchases_id', $Purchaseid)
//             ->sum('each_cost');

//         $actualQuantity = $quantity - $existingItemQuantity;
//         $actualCost = $eachCost - $existingItemCost;

//         if ($existingItem) {
//             $existingItem->quantity += $actualQuantity;
//             $existingItem->each_cost += $actualCost;
//             $existingItem->save();
//         } else {
//             purchaseProductItem::create([
//                 'imu_number' => $barcode,
//                 'purchases_id' => $Purchaseid,
//                 'product_id' => $productId,
//                 'quantity' => $quantity,
//                 'each_cost' => $eachCost,
//                 'branches_id' => $branches_id,
//                 'products_badgstock_id' => $productsBadgstockId,
//             ]);
//         }
//     }

//     return response()->json(['message' => 'Purchase items updated successfully.'], 200);
// }



// public function updatePurchaseItem(Request $request)
// {
//     $data = $request->all();
   

//     $branches_id = $data['branch'];
//     $Purchaseid = $data['Purchaseid'];
//     $mortgageData = $data['mortgageData'] ?? [];

//     // Step 1: Update total cost of the purchase
//     Purchase::where('id', $Purchaseid)->update([
//         'total_cost' => $data['totalCost'],
//         'status' => $data['PurchaseStatus']
//     ]);

//     $totalGrouped = [];

//     // Step 2: Group mortgageData by itemDataId and itemCost
//     foreach ($mortgageData as $item) {
//         $itemDataId = $item['itemDataId'];
//         $quantity = (int)$item['itemQuantity'];
//         $cost = (float)$item['itemCost'];
//         $price = (float)$item['itemPrice'];
//         $totalCost = (float)$item['totItemCost'];
//         $itemBarcode = $item['itemBarcode'];


//         $products = product::where('id', $itemDataId)->first();
//         $productsQuantity = $products->quantity;
//         $newQuantity = $productsQuantity + $quantity;
//         $diffProductsQuantity =  $newQuantity - $productsQuantity ;
//         $products->quantity += $diffProductsQuantity;
//         $products->save();

//         $compositeKey = $itemDataId . '|' . number_format($cost, 2, '.', ''). '|' . number_format($price, 2, '.', '');

//         if (!isset($totalGrouped[$compositeKey])) {
//             $totalGrouped[$compositeKey] = [
//                 'itemDataId' => $itemDataId,
//                 'itemCost' => $cost,
//                 'itemPrice' => $price,
//                 'quantity' => 0,
//                 'totalCost' => 0.0,
//                 'itemBarcode' => $itemBarcode
//             ];
//         }

//         $totalGrouped[$compositeKey]['quantity'] += $quantity;
//         $totalGrouped[$compositeKey]['totalCost'] += $totalCost;
//     }

//     // Step 3: Get existing grouped totals from DB
//     $dbTotals = purchaseProduct::selectRaw('product_id, price, each_cost, SUM(quantity) as totalQuantity, SUM(total_cost) as totalCost')
//         ->where('purchases_id', $Purchaseid)
//         ->groupBy('product_id', 'each_cost', 'price')
//         ->get()
//         ->mapWithKeys(function ($item) {
//             $formattedCost = number_format($item->each_cost, 2, '.', '');
//             return [$item->product_id . '|' . $formattedCost => $item];
//         });

//     // Step 4: Sync purchaseProductsBadgstock and purchaseProduct tables
//     foreach ($totalGrouped as $key => $group) {
//         $productId = $group['itemDataId'];
//         $eachCost = $group['itemCost'];
//         $price = $group['itemPrice'];
//         $formQty = $group['quantity'];
//         $formCost = $group['totalCost'];

//         // Update or create in purchaseProductsBadgstock
//         $existingProducts = purchaseProductsBadgstock::where('product_id', $productId)
//             ->where('branches_id', $branches_id)
//             ->where('each_cost', $eachCost)
//             ->where('price', $price)
//             ->first();

//         $existingItemQuantity = purchaseProductItem::where('product_id', $productId)
//             ->where('purchases_id', $Purchaseid)
//             ->where('each_cost', $eachCost)
//                 ->where('price', $price)
//             ->sum('quantity');

//         if ($existingProducts) {
//             $actualQuantity = ($existingProducts->quantity - $existingItemQuantity) + $formQty;

//             $existingProducts->update([
//                 'quantity' => $actualQuantity
//             ]);

//             $productsBadgstockId = $existingProducts->id;
//         } else {
//             $newBadgstock = purchaseProductsBadgstock::create([
//                 'product_id' => $productId,
//                 'purchases_id' => $Purchaseid,
//                 'quantity' => $formQty,
//                 'total_cost' => $formCost,
//                 'each_cost' => $eachCost,
//                 'price' => $price,
//                 'branches_id' => $branches_id,
//             ]);
//             $productsBadgstockId = $newBadgstock->id;
//         }

//         // Compare and update purchaseProduct
//         $dbQty = isset($dbTotals[$key]) ? (int)$dbTotals[$key]->totalQuantity : 0;
//         $dbCost = isset($dbTotals[$key]) ? (float)$dbTotals[$key]->totalCost : 0.0;

//         $quantityDiff = $formQty - $dbQty;
//         $costDiff = $formCost - $dbCost;

//         dd($dbQty);

//         if ($quantityDiff != 0 || $costDiff != 0.0) {
//             $existingProduct = purchaseProduct::where('product_id', $productId)
//                 ->where('each_cost', $eachCost)
//                 ->where('purchases_id', $Purchaseid)
//                 ->where('price', $price)
//                 ->first();

//             if ($existingProduct) {
//                 $existingProduct->update([
//                     'quantity' => DB::raw(" {$quantityDiff}"),
//                     'price' => DB::raw(" {$price}"),
//                     'total_cost' => DB::raw(" {$costDiff}")
//                 ]);
//             } else {
//                 purchaseProduct::create([
//                     'purchases_id' => $Purchaseid,
//                     'product_id' => $productId,
//                     'quantity' => $formQty,
//                     'each_cost' => $eachCost,
//                     'price'=> $price,
//                     'total_cost' => $formCost,
//                     'branches_id' => $branches_id,
//                 ]);
//             }
//         }
//     }

//     // Step 5: Update or insert into purchaseProductItem
//     foreach ($mortgageData as $item) {
//         $barcode = $item['itemBarcode'];
//         $productId = $item['itemDataId'];
//         $eachCost = $item['itemCost'];
//         $price = $item['itemPrice'];
//         $quantity = $item['itemQuantity'];

//         $existingItem = purchaseProductItem::where('imu_number', $barcode)
//             ->where('product_id', $productId)
//             ->where('purchases_id', $Purchaseid)
//              ->where('price', $price)
//             ->first();

//         $existingItemQuantity = purchaseProductItem::where('imu_number', $barcode)
//             ->where('product_id', $productId)
//             ->where('purchases_id', $Purchaseid)
//             ->where('price', $price)
//             ->sum('quantity');

//         $existingItemCost = purchaseProductItem::where('imu_number', $barcode)
//             ->where('product_id', $productId)
//             ->where('purchases_id', $Purchaseid)
//              ->where('price', $price)
//             ->sum('each_cost');

//         $actualQuantity = $quantity - $existingItemQuantity;
//         $actualCost = $eachCost - $existingItemCost;

//         if ($existingItem) {
//             $existingItem->quantity += $actualQuantity;
//             $existingItem->each_cost += $actualCost;
//             $existingItem->save();
//         } else {
//             purchaseProductItem::create([
//                 'imu_number' => $barcode,
//                 'purchases_id' => $Purchaseid,
//                 'product_id' => $productId,
//                 'quantity' => $quantity,
//                 'each_cost' => $eachCost,
//                 'price' => $price,
//                 'branches_id' => $branches_id,
//                 'products_badgstock_id' => $productsBadgstockId,
//             ]);
//         }
//     }

//     // Step 6: If preStatus is Pending and PurchaseStatus is Received, update product & stock quantities
//     if ($data['preStatus'] === 'Pending' && $data['PurchaseStatus'] === 'Received') {
//         foreach ($mortgageData as $rowData) {
//             $productId = (int) $rowData['itemDataId'];
//             $itemCost = (float) $rowData['itemCost'];
//             $price = (float) $rowData['itemPrice'];
//             $itemQuantity = (int) $rowData['itemQuantity'];

//             // Update main product table
//             $existingproducts = product::where('id', $productId)->get();

//             foreach ($existingproducts as $product) {
//                 $product->quantity += $itemQuantity;
//                 $product->save();
//             }

//             // Update purchaseProductsBadgstock
//             $existingProductsadgstock = purchaseProductsBadgstock::where('product_id', $productId)
//                 ->where('each_cost', $itemCost)
//                 ->where('price', $price)
//                 ->where('branches_id', $branches_id)
//                 ->get();

//             foreach ($existingProductsadgstock as $stock) {
//                 $stock->quantity += $itemQuantity;
//                 $stock->save();
//             }
//         }
//     }

//     return response()->json(['message' => 'Purchase items updated successfully.'], 200);
// }





public function updatePurchaseItem(Request $request)
{
    $data = $request->all();

    $branches_id = $data['branch'];
    $Purchaseid = $data['Purchaseid'];
    $mortgageData = $data['mortgageData'] ?? [];

    // Step 1: Update total cost and status
    Purchase::where('id', $Purchaseid)->update([
        'total_cost' => $data['totalCost'],
        'status' => $data['PurchaseStatus']
    ]);

    $totalGrouped = [];

    // Step 2: Group mortgageData by product, cost, and price
    foreach ($mortgageData as $item) {
        $itemDataId = $item['itemDataId'];
        $quantity = (int)$item['itemQuantity'];
        $cost = (float)$item['itemCost'];
        $price = (float)$item['itemPrice'];
        $totalCost = (float)$item['totItemCost'];
        $itemBarcode = $item['itemBarcode'];

        // Update product quantity immediately
        

        $compositeKey = $itemDataId . '|' . number_format($cost, 2, '.', '') . '|' . number_format($price, 2, '.', '');

        if (!isset($totalGrouped[$compositeKey])) {
            $totalGrouped[$compositeKey] = [
                'itemDataId' => $itemDataId,
                'itemCost' => $cost,
                'itemPrice' => $price,
                'quantity' => 0,
                'totalCost' => 0.0,
                'itemBarcode' => $itemBarcode
            ];
        }

        $totalGrouped[$compositeKey]['quantity'] += $quantity;
        $totalGrouped[$compositeKey]['totalCost'] += $totalCost;
    }

    // Step 3: Get existing grouped totals from DB (fixing composite key)
    $dbTotals = purchaseProduct::selectRaw('product_id, price, each_cost, SUM(quantity) as totalQuantity, SUM(total_cost) as totalCost')
        ->where('purchases_id', $Purchaseid)
        ->groupBy('product_id', 'each_cost', 'price')
        ->get()
        ->mapWithKeys(function ($item) {
            $formattedCost = number_format($item->each_cost, 2, '.', '');
            $formattedPrice = number_format($item->price, 2, '.', '');
            return [$item->product_id . '|' . $formattedCost . '|' . $formattedPrice => $item];
        });

    // Step 4: Sync purchaseProductsBadgstock and purchaseProduct
    foreach ($totalGrouped as $key => $group) {
        $productId = $group['itemDataId'];
        $eachCost = $group['itemCost'];
        $price = $group['itemPrice'];
        $formQty = $group['quantity'];
        $formCost = $group['totalCost'];

        // Update or create badge stock
        $existingProducts = purchaseProductsBadgstock::where('product_id', $productId)
            ->where('branches_id', $branches_id)
            ->where('each_cost', $eachCost)
            ->where('price', $price)
            ->first();

        $existingItemQuantity = purchaseProductItem::where('product_id', $productId)
            ->where('purchases_id', $Purchaseid)
            ->where('each_cost', $eachCost)
            ->where('price', $price)
            ->sum('quantity');

        if ($existingProducts) {
            $actualQuantity = ($existingProducts->quantity - $existingItemQuantity) + $formQty;
            $existingProducts->update([
                'quantity' => $actualQuantity
            ]);
            $productsBadgstockId = $existingProducts->id;
        } else {
            $newBadgstock = purchaseProductsBadgstock::create([
                'product_id' => $productId,
                'purchases_id' => $Purchaseid,
                'quantity' => $formQty,
                'total_cost' => $formCost,
                'each_cost' => $eachCost,
                'price' => $price,
                'branches_id' => $branches_id,
            ]);
            $productsBadgstockId = $newBadgstock->id;
        }

        // Compare and update purchaseProduct
        $dbQty = isset($dbTotals[$key]) ? (int)$dbTotals[$key]->totalQuantity : 0;
        $dbCost = isset($dbTotals[$key]) ? (float)$dbTotals[$key]->totalCost : 0.0;

        $quantityDiff = $formQty - $dbQty;
        $costDiff = $formCost - $dbCost;


        $product = product::find($itemDataId);
        if ($product) {
            $product->quantity += $quantityDiff;
            $product->save();
        }

        if ($quantityDiff != 0 || $costDiff != 0.0) {
            $existingProduct = purchaseProduct::where('product_id', $productId)
                ->where('each_cost', $eachCost)
                ->where('price', $price)
                ->where('purchases_id', $Purchaseid)
                ->first();

            if ($existingProduct) {
                $existingProduct->update([
                    'quantity' => $formQty,
                    'price' => $price,
                    'total_cost' => $formCost
                ]);
            } else {
                purchaseProduct::create([
                    'purchases_id' => $Purchaseid,
                    'product_id' => $productId,
                    'quantity' => $formQty,
                    'each_cost' => $eachCost,
                    'price'=> $price,
                    'total_cost' => $formCost,
                    'branches_id' => $branches_id,
                ]);
            }
        }
    }

    // Step 5: Update or insert into purchaseProductItem
    foreach ($mortgageData as $item) {
        $barcode = $item['itemBarcode'];
        $productId = $item['itemDataId'];
        $eachCost = $item['itemCost'];
        $price = $item['itemPrice'];
        $quantity = $item['itemQuantity'];

        $existingItem = purchaseProductItem::where('imu_number', $barcode)
            ->where('product_id', $productId)
            ->where('purchases_id', $Purchaseid)
            ->where('price', $price)
            ->first();

        $existingItemQuantity = purchaseProductItem::where('imu_number', $barcode)
            ->where('product_id', $productId)
            ->where('purchases_id', $Purchaseid)
            ->where('price', $price)
            ->sum('quantity');

        $existingItemCost = purchaseProductItem::where('imu_number', $barcode)
            ->where('product_id', $productId)
            ->where('purchases_id', $Purchaseid)
            ->where('price', $price)
            ->sum('each_cost');

        $actualQuantity = $quantity - $existingItemQuantity;
        $actualCost = $eachCost - $existingItemCost;

        if ($existingItem) {
            $existingItem->quantity += $actualQuantity;
            $existingItem->each_cost += $actualCost;
            $existingItem->save();
        } else {
            purchaseProductItem::create([
                'imu_number' => $barcode,
                'purchases_id' => $Purchaseid,
                'product_id' => $productId,
                'quantity' => $quantity,
                'each_cost' => $eachCost,
                'price' => $price,
                'branches_id' => $branches_id,
                'products_badgstock_id' => $productsBadgstockId,
            ]);
        }
    }

    // Step 6: If status changed from Pending to Received, update product and stock quantities again
    if ($data['preStatus'] === 'Pending' && $data['PurchaseStatus'] === 'Received') {
        foreach ($mortgageData as $rowData) {
            $productId = (int) $rowData['itemDataId'];
            $itemCost = (float) $rowData['itemCost'];
            $price = (float) $rowData['itemPrice'];
            $itemQuantity = (int) $rowData['itemQuantity'];

            // Update product
            $product = product::find($productId);
            if ($product) {
                $product->quantity += $itemQuantity;
                $product->save();
            }

            // Update badge stock
            $badgeStocks = purchaseProductsBadgstock::where('product_id', $productId)
                ->where('each_cost', $itemCost)
                ->where('price', $price)
                ->where('branches_id', $branches_id)
                ->get();

            foreach ($badgeStocks as $stock) {
                $stock->quantity += $itemQuantity;
                $stock->save();
            }
        }
    }

    return response()->json(['message' => 'Purchase items updated successfully.'], 200);
}


    

// public function updatePurchaseItem(Request $request)
// {
//     $data = $request->all();
//     // dd($data);
    
//     $branches_id = $data['branch'];
//     $Purchaseid = $data['Purchaseid'];
//     $productsBadgstockId = null;
//     $mortgageData = $data['mortgageData'] ?? [];

//     // Update the main purchase table
//     Purchase::where('id', $Purchaseid)->update([
//         'total_cost' => $data['totalCost']
//     ]);

//     // Try to find an existing purchaseProduct
//     $productItems = purchaseProduct::where('purchases_id', $Purchaseid)
//         ->where('product_id', $data['itemDataId'])
//         ->first();

//     // Calculate current values
//     $existingQuantitySum = purchaseProduct::where('product_id', $data['itemDataId'])
//         ->where('each_cost', $data['itemCost'])
//         ->sum('quantity');

//     $existingCostSum = purchaseProduct::where('product_id', $data['itemDataId'])
//         ->where('each_cost', $data['itemCost'])
//         ->sum('total_cost');

//     $brandQuantitySum = purchaseProduct::where('product_id', $data['itemDataId'])->sum('quantity');

//     if ($productItems) {
//         // Update existing purchase product
//         $productItems->quantity = $data['totalQuantity'];
//         $productItems->total_cost = $data['totalCost'];
//         $productItems->each_cost = $data['itemCost'];
//         $productItems->save();

//         // Recalculate after update
//         $brandnewQuantitySum = purchaseProduct::where('product_id', $data['itemDataId'])->sum('quantity');
//         $newQuantitySum = purchaseProduct::where('product_id', $data['itemDataId'])
//             ->where('each_cost', $data['itemCost'])
//             ->sum('quantity');
//         $newTotalCostSum = purchaseProduct::where('product_id', $data['itemDataId'])
//             ->where('each_cost', $data['itemCost'])
//             ->sum('total_cost');

//         $QuantityBalance = $newQuantitySum - $existingQuantitySum;
//         $TotalCostSumBalance = $newTotalCostSum - $existingCostSum;
//         $brandQuantityBalance = $brandnewQuantitySum - $brandQuantitySum;

//         $existingProducts = purchaseProductsBadgstock::where('product_id', $data['itemDataId'])
//             ->where('each_cost', $data['itemCost'])->first();

//         $existingpurchaseProductsBadgstockSum = purchaseProductsBadgstock::where('product_id', $data['itemDataId'])
//             ->where('each_cost', $data['itemCost'])->sum('quantity');

//         $actualBadgstockSum = $existingpurchaseProductsBadgstockSum - $data['totalQuantity'];

//         if ($existingProducts) {
//             if ($existingProducts->each_cost == $data['itemCost']) {
//                 $existingProducts->quantity += $QuantityBalance;
//                 $existingProducts->total_cost += $TotalCostSumBalance;
//                 $existingProducts->save();
//                 $productsBadgstockId = $existingProducts->id;
//             } else {
//                 $existingProducts->quantity += $actualBadgstockSum;
//                 $existingProducts->save();

//                 $newBadgstock = purchaseProductsBadgstock::create([
//                     'product_id' => $data['itemDataId'],
//                     'purchases_id' => $Purchaseid,
//                     'quantity' => $data['totalQuantity'],
//                     'total_cost' => $data['totalCost'],
//                     'each_cost' => $data['itemCost'],
//                     'branches_id' => $branches_id,
//                 ]);

//                 $productsBadgstockId = $newBadgstock->id;
//             }
//         } else {
//             $secoundnewBadgstock = purchaseProductsBadgstock::create([
//                 'product_id' => $data['itemDataId'],
//                 'purchases_id' => $Purchaseid,
//                 'quantity' => $data['totalQuantity'],
//                 'total_cost' => $data['totalCost'],
//                 'each_cost' => $data['itemCost'],
//                 'branches_id' => $branches_id,
//             ]);

//             $productsBadgstockId = $secoundnewBadgstock->id;
//         }

//         // Update main product stock quantity
//         $existingbrands = product::where('id', $data['itemDataId'])->first();
//         if ($existingbrands) {
//             $existingbrands->quantity += $brandQuantityBalance;
//             $existingbrands->save();
//         }

//         // Handle item-level mortgage data
//         foreach ($mortgageData as $rowData) {
//             $existingItem = purchaseProductItem::where('imu_number', $rowData['itemBarcode'])
//                 ->where('product_id', $rowData['itemDataId'])
//                 ->where('purchases_id', $Purchaseid)
//                 ->first();

//             $existingItemQuantity = purchaseProductItem::where('imu_number', $rowData['itemBarcode'])
//                 ->where('product_id', $rowData['itemDataId'])
//                 ->where('purchases_id', $Purchaseid)
//                 ->sum('quantity');

//             $existingItemcost = purchaseProductItem::where('imu_number', $rowData['itemBarcode'])
//                 ->where('product_id', $rowData['itemDataId'])
//                 ->where('purchases_id', $Purchaseid)
//                 ->sum('each_cost');

//             $actualgItemQuantity = $rowData['itemQuantity'] - $existingItemQuantity;
//             $actualgItemcost = $rowData['itemCost'] - $existingItemcost;

//             if ($existingItem) {
//                 $existingItem->quantity += $actualgItemQuantity;
//                 $existingItem->each_cost += $actualgItemcost;
//                 $existingItem->save();
//             } else {
//                 purchaseProductItem::create([
//                     'imu_number' => $rowData['itemBarcode'],
//                     'purchases_id' => $Purchaseid,
//                     'product_id' => $rowData['itemDataId'],
//                     'quantity' => $rowData['itemQuantity'],
//                     'each_cost' => $rowData['itemCost'],
//                     'branches_id' => $branches_id,
//                     'products_badgstock_id' => $productsBadgstockId,
//                 ]);
//             }
//         }

//     } else {
//         // New purchaseProduct, so also create a Badgstock record
//         $newpurchaseProduct = purchaseProduct::create([
//             'purchases_id' => $Purchaseid,
//             'product_id' => $data['itemDataId'],
//             'quantity' => $data['itemQuantity'],
//             'each_cost' => $data['itemCost'],
//             'total_cost' => $data['totItemCost'],
//             'branches_id' => $branches_id,
//         ]);

//         $createdBadgstock = purchaseProductsBadgstock::create([
//             'product_id' => $data['itemDataId'],
//             'purchases_id' => $Purchaseid,
//             'quantity' => $data['itemQuantity'],
//             'total_cost' => $data['totItemCost'],
//             'each_cost' => $data['itemCost'],
//             'branches_id' => $branches_id,
//         ]);

//         $productsBadgstockId = $createdBadgstock->id;

//         // Insert all mortgage items
//         if ($newpurchaseProduct) {
//             foreach ($mortgageData as $rowData) {
//                 purchaseProductItem::create([
//                     'imu_number' => $rowData['itemBarcode'],
//                     'purchases_id' => $Purchaseid,
//                     'product_id' => $rowData['itemDataId'],
//                     'quantity' => $rowData['itemQuantity'],
//                     'each_cost' => $rowData['itemCost'],
//                     'branches_id' => $branches_id,
//                     'products_badgstock_id' => $productsBadgstockId,
//                 ]);
//             }
//         }
//     }
// }


// Return a success response

    public function storePpurchase(Request $request)
    {
        $data = $request->all();
        $branches_id = $data['branch'];
  
        // dd($data);
        
        if( $data['PurchaseType']=="Add Product"){
            $purchase = purchase::create([
                'purchases_id' =>  $data['purchaseNo'],
                'purchases_type' =>  $data['PurchaseType'],      
                'date' =>  $data['dateInput'],
                'total_cost' =>  $data['totalCost'],
                'total_paid' =>  $data['paidAmount'],
                'status'=>  $data['PurchaseStatus'], 
                'supplier_id' =>  $data['supplier'],
                'branch_id'=>  $data['branch'],   
            ]);
            
            if($data['paidAmount'] > 0 ){
                purchasePayment::create([
                    'purchases_id' => $purchase->id,
                    'date' => Carbon::now()->toDateString(),
                    'amount' => $data['paidAmount'],
                    'method' => $data['PaymentMethods'],
                    'sale_note' => $data['SaleNote'],
                    'staff_note' => $data['StaffNote'],
                ]);
            }


            $mortgageData = isset($data['mortgageData']) ? $data['mortgageData'] : [];

            foreach ($mortgageData as $rowData) {
                // Retrieve all existing products with the same `product_id`
                $existingProducts = purchaseProductsBadgstock::where('product_id', $rowData['itemDataId'])->get();
                $product = Product::where('id', $rowData['itemDataId'])->first();

                
                $matched = false; // Flag to check if a matching product is found
                if($data['PurchaseStatus'] == "Received"){
                if($product){
                    $product->quantity += $rowData['itemQuantity'];
                    $product->save();
                }


                    if ($existingProducts->isNotEmpty()) {
                        foreach ($existingProducts as $existingProduct) {

                            if ($existingProduct->each_cost == 0 && $existingProduct->price == $rowData['itemPrice'] && $existingProduct->branches_id == 0) {
                                // Update the existing row's quantity and total cost
                                $existingProduct->quantity += $rowData['itemQuantity'];
                                $existingProduct->each_cost = $rowData['each_cost'];
                                $existingProduct->branches_id = $branches_id;
                                $existingProduct->purchases_id = $purchase->id;
                                $existingProduct->total_cost += $rowData['totItemCost'];
                                $existingProduct->save();
                                $matched = true; // Mark as matched
                                break; // Exit loop once matched
                            }
                            // Check if the cost matches
                            if ($existingProduct->each_cost == $rowData['itemCost'] && $existingProduct->price == $rowData['itemPrice'] && $existingProduct->branches_id == $branches_id) {
                                // Update the existing row's quantity and total cost
                                $existingProduct->quantity += $rowData['itemQuantity'];
                                $existingProduct->total_cost += $rowData['totItemCost'];
                                $existingProduct->save();
                                $matched = true; // Mark as matched
                                break; // Exit loop once matched
                            }
                        }
                    }
                
                    // If no matching product was found, insert a new row
                    if (!$matched) {
                        purchaseProductsBadgstock::create([
                            'product_id' => $rowData['itemDataId'],
                            'purchases_id' => $purchase->id,
                            'quantity' => $rowData['itemQuantity'],
                            'branches_id' => $branches_id,
                            'total_cost' => $rowData['totItemCost'],
                            'each_cost' => $rowData['itemCost'],
                            'price' => $rowData['itemPrice'],
                        ]);
                    }
                }
               

                purchaseProduct::create([
                    'purchases_id' => $purchase->id,
                    'quantity' => $rowData['itemQuantity'],
                    'product_id' => $rowData['itemDataId'],
                    'total_cost' => $rowData['totItemCost'],
                    'each_cost' => $rowData['itemCost'],
                    'price' => $rowData['itemPrice'],
                    'branches_id' => $branches_id,
                ]);
            }
            
        }
        // else if($data['PurchaseType']=="Add Product By Items"){
        //     dd("me");
        // }

    }

    public function storePpurchaseByItems(Request $request)
{
    $data = $request->all();
    $branches_id = $data['branch'];

    // Validate required fields before proceeding
    if (!isset($data['purchaseNo'], $data['PurchaseType'], $data['dateInput'], $data['totalCost'])) {
        return response()->json(['error' => 'Missing required fields'], 400);
    }

    DB::beginTransaction();

    try {
        // Create main purchase record
        $purchase = Purchase::create([
            'purchases_id'   => $data['purchaseNo'],
            'purchases_type' => $data['PurchaseType'],
            'date'           => $data['dateInput'],
            'total_cost'     => $data['totalCost'],
            'total_paid'     => $data['paidAmount'] ?? 0,
            'status'         => $data['PurchaseStatus'] ?? 'pending',
            'supplier_id'    => $data['supplier'] ?? null,
            'branch_id'      => $data['branch'] ?? null,
        ]);

        // Record payment if applicable
        if (!empty($data['paidAmount']) && $data['paidAmount'] > 0) {
            purchasePayment::create([
                'purchases_id' => $purchase->id,
                'date'         => Carbon::now()->toDateString(),
                'amount'       => $data['paidAmount'],
                'method'       => $data['PaymentMethods'],
                'sale_note'    => $data['SaleNote'] ?? null,
                'staff_note'   => $data['StaffNote'] ?? null,
            ]);
        }

        $mortgageData = $data['mortgageData'] ?? [];
        $groupedData = [];

        foreach ($mortgageData as $rowData) {
            // Initialize flags for each loop
            $matched = false;
            $productsBadgstockId = null;

            // Group data for summary insertion later
            $key = $rowData['itemDataId'] . '-' . $rowData['totItemCost'];
            if (!isset($groupedData[$key])) {
                $groupedData[$key] = [
                    'totItemCost'  => $rowData['totItemCost'],
                    'itemDataId'   => $rowData['itemDataId'],
                    'itemCost'     => $rowData['itemCost'],
                    'itemPrice'    => $rowData['itemPrice'],
                    'itemQuantity' => $rowData['itemQuantity'],
                ];
            } else {
                $groupedData[$key]['itemQuantity'] += $rowData['itemQuantity'];
                $groupedData[$key]['totItemCost'] += $rowData['totItemCost'];
            }

            // Fetch existing stock for this product + branch
            $existingProducts = purchaseProductsBadgstock::where('product_id', $rowData['itemDataId'])
                ->where('branches_id', $branches_id)
                ->get();

            // -------------------------------------------
            // IF PURCHASE STATUS = RECEIVED
            // -------------------------------------------
            if ($data['PurchaseStatus'] === "Received") {

                // Update total stock quantity in Product table
                $product = Product::find($rowData['itemDataId']);
                if ($product) {
                    $product->quantity += $rowData['itemQuantity'];
                    $product->save();
                }

                // Try to find an existing matching batch
                if ($existingProducts->isNotEmpty()) {
                    foreach ($existingProducts as $existingProduct) {
                        if (
                            abs($existingProduct->each_cost - $rowData['itemCost']) < 0.01 &&
                            abs($existingProduct->price - $rowData['itemPrice']) < 0.01
                        ) {
                            // Match found - update existing batch
                            $existingProduct->quantity += $rowData['itemQuantity'];
                            $existingProduct->total_cost += $rowData['totItemCost'];
                            $existingProduct->save();

                            $productsBadgstockId = $existingProduct->id;
                            $matched = true;
                            break;
                        }
                    }
                }

                // No matching record → create new batch
                if (!$matched) {
                    $newBadgstock = purchaseProductsBadgstock::create([
                        'product_id'  => $rowData['itemDataId'],
                        'purchases_id'=> $purchase->id,
                        'quantity'    => $rowData['itemQuantity'],
                        'total_cost'  => $rowData['totItemCost'],
                        'branches_id' => $branches_id,
                        'each_cost'   => $rowData['itemCost'],
                        'price'       => $rowData['itemPrice'],
                    ]);

                    $productsBadgstockId = $newBadgstock->id;
                }
            }

            // -------------------------------------------
            // IF PURCHASE STATUS = PENDING
            // -------------------------------------------
            if ($data['PurchaseStatus'] === "Pending") {
                if ($existingProducts->isNotEmpty()) {
                    foreach ($existingProducts as $existingProduct) {
                        if (
                            abs($existingProduct->each_cost - $rowData['itemCost']) < 0.01 &&
                            abs($existingProduct->price - $rowData['itemPrice']) < 0.01
                        ) {
                            $productsBadgstockId = $existingProduct->id;
                            $matched = true;
                            break;
                        }
                    }
                }

                // No existing batch → create new (zero quantity)
                if (!$matched) {
                    $newBadgstock = purchaseProductsBadgstock::create([
                        'product_id'  => $rowData['itemDataId'],
                        'purchases_id'=> $purchase->id,
                        'quantity'    => 0,
                        'total_cost'  => $rowData['totItemCost'],
                        'branches_id' => $branches_id,
                        'each_cost'   => $rowData['itemCost'],
                        'price'       => $rowData['itemPrice'],
                    ]);

                    $productsBadgstockId = $newBadgstock->id;
                }
            }

            // -------------------------------------------
            // CREATE PURCHASE PRODUCT ITEM
            // -------------------------------------------
            purchaseProductItem::create([
                'imu_number'            => $rowData['itemBarcode'],
                'purchases_id'          => $purchase->id,
                'product_id'            => $rowData['itemDataId'],
                'quantity'              => $rowData['itemQuantity'],
                'each_cost'             => $rowData['itemCost'],
                'price'                 => $rowData['itemPrice'],
                'products_badgstock_id' => $productsBadgstockId,
                'branches_id'           => $branches_id,
            ]);
        }

        // -------------------------------------------
        // INSERT GROUPED PURCHASE PRODUCTS
        // -------------------------------------------
        foreach ($groupedData as $rowData) {
            purchaseProduct::create([
                'purchases_id' => $purchase->id,
                'product_id'   => $rowData['itemDataId'],
                'quantity'     => $rowData['itemQuantity'],
                'total_cost'   => $rowData['totItemCost'],
                'branches_id'  => $branches_id,
                'each_cost'    => $rowData['itemCost'],
                'price'        => $rowData['itemPrice'],
            ]);
        }

        DB::commit();
        return response()->json(['success' => true, 'message' => 'Purchase stored successfully']);

    } catch (\Exception $e) {
        DB::rollBack();
        return response()->json(['error' => 'Failed to store purchase', 'message' => $e->getMessage()], 500);
    }
}

    



    public function Purchaselist()
    {
        
       $purchases = purchase::leftJoin('purchase_products', 'purchases.id', '=', 'purchase_products.purchases_id')
    ->leftJoin('people', 'purchases.supplier_id', '=', 'people.id')
    ->select(
        'purchases.id',
        'purchases.date',
        'purchases.purchases_id',
        'purchases.total_paid',
        'purchases.total_cost',
        DB::raw('(purchases.total_cost - purchases.total_paid) as outstanding_amount'),
        'purchases.status',
        'people.name',
        DB::raw('SUM(purchase_products.quantity) as total_quantity')
    )
    ->groupBy(
        'purchases.id',
        'purchases.date',
        'purchases.purchases_id',
        'purchases.total_paid',
        'purchases.total_cost',
        'purchases.status',
        'people.name'
    )
    ->get();

  
        $response['data'] = $purchases;
        return response()->json($response);

    }



        public function PurchaselistByDate($date)
    {
        
       $purchases = purchase::leftJoin('purchase_products', 'purchases.id', '=', 'purchase_products.purchases_id')
        ->leftJoin('people', 'purchases.supplier_id', '=', 'people.id')
        ->whereDate('purchases.date', $date) 
        ->select(
        'purchases.id',
        'purchases.date',
        'purchases.purchases_id',
        'purchases.total_paid',
        'purchases.total_cost',
        DB::raw('(purchases.total_cost - purchases.total_paid) as outstanding_amount'),
        'purchases.status',
        'people.name',
        DB::raw('SUM(purchase_products.quantity) as total_quantity')
    )
    ->groupBy(
        'purchases.id',
        'purchases.date',
        'purchases.purchases_id',
        'purchases.total_paid',
        'purchases.total_cost',
        'purchases.status',
        'people.name'
    )
    ->get();

  
        $response['data'] = $purchases;
        return response()->json($response);

    }


  public function PurchaseOrderlist()
    {
        
        $purchases = purchase::leftJoin('purchase_products', 'purchases.id', '=', 'purchase_products.purchases_id')
       ->leftJoin('people', 'purchases.supplier_id', '=', 'people.id')
        ->where('purchases.status', 'Pending')
        ->select(
            'purchases.id',
            'purchases.date',
            'purchases.purchases_id',
            'purchases.total_paid',
            'purchases.total_cost',
            'purchases.status',
            'people.name',
            DB::raw('SUM(purchase_products.quantity) as total_quantity')
        )
        ->groupBy('purchases.total_paid','purchases.status','purchases.purchases_id', 'purchases.id', 'purchases.date', 'purchases.total_cost','people.name')
        ->get();
  
        $response['data'] = $purchases;
        return response()->json($response);

    }
    
    public function deletePurchaseProduct(Request $request)
    {

        $data = $request->all();
        $purchaseProductsBadgstock = purchaseProductsBadgstock::where('product_id', $data['product_id'])
        ->where('each_cost', $data['each_cost'])
        ->first();
    
        $purchaseProductsBadgstock->quantity -= $data['quantity'];
        $purchaseProductsBadgstock->total_cost -= $data['totalCost'];
        $purchaseProductsBadgstock->save();
    
        $product = product::where('id', $data['product_id'])
        ->first();
    
        $product->quantity -= $data['quantity'];
        $product->save();

    if($data['type']='product'){
       

        $purchaseProduct = purchaseProduct::where('product_id', $data['product_id'])
        ->where('id', $data['id'])
        ->delete();

    }
    if($data['type']='product by items'){
        $purchaseProduct = purchaseProduct::where('product_id', $data['product_id'])
        ->where('purchases_id', $data['purchases_id'])
        ->where('each_cost', $data['each_cost'])->first();

        $purchaseProduct->quantity -= $data['quantity'];
        $purchaseProduct->total_cost -= $data['totalCost'];
        $purchaseProduct->save();


        $purchaseProductItem = purchaseProductItem::where('id', $data['id'])
        ->where('imu_number', $data['imu_number'])
        ->delete();

    }
}

    public function returnPurchaceProduct(Request $request)
    {
        $data = $request->all();
        $id =$data['id'];
       

        $ToDoList = ToDoList::get();
        $branches = branches::get();
        $purchase = purchase::where('id', $id)->first();
        $purchaseType = $purchase->purchases_type;

        $products = purchaseProduct::leftJoin('products','purchase_products.product_id','=','products.id')
        ->where('purchase_products.purchases_id', $id)->select('purchase_products.*','products.name as product_name')->first();

        $purchaseProducts = purchaseProduct::leftJoin('products','purchase_products.product_id','=','products.id')
        ->leftJoin('purchases','purchase_products.purchases_id','=','purchases.id')
        ->leftJoin('people','purchases.supplier_id','=','people.id')
        ->leftJoin('product_brand_categories','products.product_brand_id','=','product_brand_categories.id')
        ->where('purchase_products.purchases_id', $id)->select('purchase_products.*','products.name as product_name','product_brand_categories.product_brand_name','people.id as supplier_id')->get();
        
        $purchaseProductItems = purchaseProductItem::leftJoin('products','purchase_product_items.product_id','=','products.id')
        ->where('purchases_id', $purchase->id)
        ->select('purchase_product_items.*','products.name')->get(); 

        
        $totalProdutCost = $purchaseProducts->sum('total_cost');
        $totalProdutQuantity = $purchaseProducts->sum('quantity');

        $suppliers = People::where('type', 'Supplier')->get();
        if($purchaseType == 'Add Product'){
            return view('Section.Purchase.returnPurchase.returntPurchaceProduct',compact('ToDoList','purchaseProductItems','purchase' ,'suppliers','branches','purchaseProducts','totalProdutCost','totalProdutQuantity'));
        }
        if($purchaseType == 'Add Product By Items'){
            return view('Section.Purchase.returnPurchase.returnPurchaceProductItems',compact('ToDoList','purchaseProductItems','purchase' ,'suppliers','branches','purchaseProducts','totalProdutCost','totalProdutQuantity','products'));
        }

    }   

    public function searchProductForReturn(Request $request, $id)
    {
        // Fetch the query string for product name or code
        $query = $request->get('query');
    
        // Fetch matching products related to the specific purchase ID
        $suggestions = purchaseProduct::leftJoin('products', 'purchase_products.product_id', '=', 'products.id')
            ->where('purchase_products.purchases_id', $id) // Match purchase ID
            ->where(function ($q) use ($query) {
                $q->where('products.name', 'like', "%{$query}%")
                  ->orWhere('products.code', 'like', "%{$query}%");
            })
            ->limit(10)
            ->get(['products.id', 'products.name', 'products.code', 'purchase_products.quantity', 'purchase_products.each_cost']); // Select specific columns
    
        // Check if any suggestions were found
        if ($suggestions->isEmpty()) {
            return response()->json([
                'success' => false,
                'message' => 'No products found for the given query.'
            ], 404);
        }
    
        // Return the suggestions as JSON
        return response()->json([
            'success' => true,
            'suggestions' => $suggestions
        ]);
    }


    public function searchProductItemsForReturn(Request $request, $id)
    {
        // Fetch the query string for product name or code
        $query = $request->get('query');
    
        // Fetch matching products related to the specific purchase ID
        $suggestions = purchaseProductItem::leftJoin('products', 'purchase_product_items.product_id', '=', 'products.id')
    ->where('purchase_product_items.purchases_id', $id) // Match purchase ID
    ->where(function ($q) use ($query) {
        $q->where('products.name', 'like', "%{$query}%")
          ->orWhere('products.code', 'like', "%{$query}%")
          ->orWhere('purchase_product_items.imu_number', 'like', "%{$query}%");
    })
    ->select([
        'purchase_product_items.imu_number',
        'purchase_product_items.id as product_items_id',
        'products.id',
        'products.name',
        'products.code',
        'purchase_product_items.quantity',
        'purchase_product_items.each_cost'
    ])
    ->groupBy([
        'purchase_product_items.imu_number',
        'purchase_product_items.id',
        'products.id',
        'products.name',
        'products.code',
        'purchase_product_items.quantity',
        'purchase_product_items.each_cost'
    ]) // Group by all selected columns to avoid ONLY_FULL_GROUP_BY error
    ->limit(10)
    ->get();

    
    

        // $suggestions = purchaseProductItem::leftJoin('products','purchase_product_items.product_id','=','products.id')
        // ->leftJoin('purchase_products','products.id','=','purchase_products.product_id')
        // ->where('purchase_products.purchases_id', $id) // Match purchase ID
        // ->where(function ($q) use ($query) {
        //         $q->where('products.name', 'like', "%{$query}%")
        //           ->orWhere('products.code', 'like', "%{$query}%")
        //           ->orWhere('purchase_product_items.imu_number', 'like', "%{$query}%");
        //     })
        // ->select('purchase_product_items.imu_number','purchase_product_items.id as product_items_id','products.id', 'products.name', 'products.code', 'purchase_product_items.quantity', 'purchase_products.each_cost')->get(); 

        // Check if any suggestions were found
        if ($suggestions->isEmpty()) {
            return response()->json([
                'success' => false,
                'message' => 'No products found for the given query.'
            ], 404);
        }
    
        // Return the suggestions as JSON
        return response()->json([
            'success' => true,
            'suggestions' => $suggestions
        ]);
    }
    
    
    public function returnPurchase(Request $request)
    {
        $data = $request->all();
     
        $purchase = Purchase::find($data['id']);
        $purchase->total_cost -= $data['totalCost']; // Subtract and update the value
        $purchase->save();

        if($data['PurchaseType']=='product'){

      
        $mortgageData = isset($data['mortgageData']) ? $data['mortgageData'] : [];

        foreach ($mortgageData as $rowData) {

            $purchaseProductsBadgstock = purchaseProductsBadgstock::where('product_id', $rowData['itemDataId'])
            ->where('each_cost', $rowData['itemCost'])
            ->first();
            
           
           

        if ($purchaseProductsBadgstock) {
            $purchaseProductsBadgstock->quantity -= $rowData['itemQuantity'];
            $purchaseProductsBadgstock->total_cost -= $rowData['totItemCost'];
            $purchaseProductsBadgstock->save();
        }

        // Update product
        $product = product::where('id', $rowData['itemDataId'])->first();

        if ($product) {
            $product->quantity -= $rowData['itemQuantity'];
            $product->save();
        }

        // Update purchaseProduct
        $purchaseProduct = purchaseProduct::where('product_id', $rowData['itemDataId'])
            ->where('purchases_id', $data['id'])
            ->first();

        if ($purchaseProduct) {
            $purchaseProduct->quantity -= $rowData['itemQuantity'];
            $purchaseProduct->total_cost -= $rowData['totItemCost'];
            $purchaseProduct->save();
        }

        returnProduct::create([
            'purchases_id' => $data['id'],
            'product_id' => $rowData['itemDataId'],
            'quantity' => $rowData['itemQuantity'],
            'each_cost' => $rowData['itemCost'],
        ]);
    
    }


}
    
    if($data['PurchaseType']=='product by items'){

        dd($data);
   
    $mortgageData = isset($data['mortgageData']) ? $data['mortgageData'] : [];
    $groupedData = [];

    foreach ($mortgageData as $rowData) {
   
        $purchaseProductItem = purchaseProductItem::where('id', $data['id'])
        ->where('imu_number', $data['imu_number'])
        ->delete();

        $key = $rowData['itemDataId'];

        if (!isset($groupedData[$key])) {
            // First occurrence, add entry
            $groupedData[$key] = [
                'itemBarcode' => $rowData['itemBarcode'],
                'itemQuantity' => (int) $rowData['itemQuantity'],
                'itemCost' => (float) $rowData['itemCost'],
                'itemDataId' => $rowData['itemDataId'],
                'totItemCost' => (float) $rowData['totItemCost'],
            ];
        } else {
            // Already exists, update quantity and total cost
            $groupedData[$key]['itemQuantity'] += (int) $rowData['itemQuantity'];
        }

        
    }

    foreach ($groupedData as $rowData) {

      

        $purchaseProduct = purchaseProduct::where('product_id', $rowData['itemDataId'])
        ->where('purchases_id', $data['id'])
        ->first();

        if ($purchaseProduct) {
            $purchaseProduct->quantity -= $rowData['itemQuantity'];
            $purchaseProduct->total_cost -= $rowData['totItemCost'];
            $purchaseProduct->save();
        }

        $purchaseProductsBadgstock = purchaseProductsBadgstock::where('product_id', $rowData['itemDataId'])
        ->where('each_cost', $rowData['itemCost'])
        ->first();
        

        if ($purchaseProductsBadgstock) {
            $purchaseProductsBadgstock->quantity -= $rowData['itemQuantity'];
            $purchaseProductsBadgstock->total_cost -= $rowData['totItemCost'];
            $purchaseProductsBadgstock->save();
        }

        $product = product::where('id', $rowData['itemDataId'])->first();

        if ($product) {
            $product->quantity -= $rowData['itemQuantity'];
            $product->save();
        }
    }


        // $purchaseProductItem = purchaseProductItem::where('id', $data['id'])
        // ->where('imu_number', $data['imu_number'])
        // ->delete();
  
    }
    

    }

     public function storePurchasePayment(Request $request)
{
    $data = $request->all();
    // dd($data);

    if ($data['receivedAmount'] > 0) {
        // Save the payment
        purchasePayment::create([
            'purchases_id'  => $data['id'],
            'date'          => $data['date'],
            'amount'        => $data['receivedAmount'],
            'method'        => $data['PaymentMethods'],
            'payment_note'  => $data['PaymentNote'],
            'purchases_note'     => $data['SaleNote'],
            'staff_note'    => $data['StaffNote'],
        ]);

        // Update the sale record
        $purchase = purchase::find($data['id']);

        if ($purchase) {
            // Increment the received amount
            $purchase->total_paid += $data['receivedAmount'];

            $purchase->save();
        }
    }
}
  
//  public function storePayment(Request $request)
// {
//     $data = $request->all();

//     if ($data['receivedAmount'] > 0) {
//         // Save the payment
//         salesPayment::create([
//             'sale_id'       => $data['sale_id'],
//             'date'          => $data['date'],
//             'amount'        => $data['receivedAmount'],
//             'method'        => $data['PaymentMethods'],
//             'payment_note'  => $data['PaymentNote'],
//             'sale_note'     => $data['SaleNote'],
//             'staff_note'    => $data['StaffNote'],
//         ]);

//         // Update the sale record
//         $sale = sale::find($data['sale_id']);

//         if ($sale) {
//             // Increment the received amount
//             $sale->received_amount += $data['receivedAmount'];

//             // Recalculate the outstanding amount
//             $sale->outstanding_amount  -= $data['outstandingAmount'];

//             $sale->save();
//         }
//     }
// }



}
