<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Expenses;
use App\Models\pettyCash;
use App\Models\Branches;
use App\Models\ToDoList;
use Illuminate\Support\Facades\DB;
class reportController extends Controller
{
    
    
    public function getMonthlyReport()
    {   
        $ToDoList = ToDoList::get();
        $Expenses = Expenses::sum('amount');
        $pettyCash= pettyCash::sum('amount');
        return view('Section.Reports.monthlyReport',compact('Expenses','pettyCash','ToDoList'));
      
    }
    public function getAnnualyReport()
    {   
        $ToDoList = ToDoList::get();
        $Expenses = Expenses::sum('amount');
        $pettyCash= pettyCash::sum('amount');
        return view('Section.Reports.AnnuallyReport',compact('Expenses','pettyCash','ToDoList'));
      
    }

    public function getBranchReport()
    {   
        $ToDoList = ToDoList::get();
        $Expenses = Expenses::sum('amount');
        $pettyCash= pettyCash::sum('amount');
        return view('Section.Reports.BranchReport',compact('Expenses','pettyCash','ToDoList'));
      
    }

    
    
    public function getDailyReport()
    {   
        $ToDoList = ToDoList::get();
        $Expenses = Expenses::sum('amount');
        $pettyCash= pettyCash::sum('amount');
        return view('Section.Reports.DailyReport',compact('Expenses','pettyCash','ToDoList'));
      
    }


    public function monthlyReportData(Request $request)
    {
        $date = $request->query('date');
        $ToDoList = ToDoList::get();
        return view('Section.Reports.monthlyReportData',compact('date','ToDoList'));
    }

    public function annualyReportData(Request $request)
    {
        $date = $request->query('date');
        $ToDoList = ToDoList::get();
        return view('Section.Reports.AnnuallyReportData',compact('date','ToDoList'));
    }
    public function dailyReportData(Request $request)
    {
        $date = $request->query('date');
        $ToDoList = ToDoList::get();
        return view('Section.Reports.DailyReportData',compact('date','ToDoList'));
    }


    public function branchReportData(Request $request)
    {
        $branch = $request->query('branch');
        $ToDoList = ToDoList::get();
        return view('Section.Reports.BranchReportData',compact('branch','ToDoList'));
    }

    
    

    
    public function getAnalytic()
    {
    

     $expensesQuery = DB::table('expenses')
        ->select(
   DB::raw('YEAR(date) AS year'),
            DB::raw('MONTH(date) AS month'),
            DB::raw('SUM(amount) AS total_expenses'),
            DB::raw('0 AS total_petty_cash'),
            DB::raw('0 AS purchase_amount'),
            DB::raw('0 AS total_Sale_amount')
        )
       ->groupBy(DB::raw('YEAR(date), MONTH(date)'));

    // Total sales payments by day
    $salePaymentQuery = DB::table('sales_payments')
        ->select(
   DB::raw('YEAR(date) AS year'),
            DB::raw('MONTH(date) AS month'),
            DB::raw('0 AS total_expenses'),
            DB::raw('0 AS total_petty_cash'),
            DB::raw('0 AS purchase_amount'),
            DB::raw('SUM(amount) AS total_Sale_amount')
        )
       ->groupBy(DB::raw('YEAR(date), MONTH(date)'));

    // Total purchase payments by day
    $purchasePaymentsQuery = DB::table('purchase_payments')
        ->select(
   DB::raw('YEAR(date) AS year'),
            DB::raw('MONTH(date) AS month'),
            DB::raw('0 AS total_expenses'),
            DB::raw('0 AS total_petty_cash'),
            DB::raw('SUM(amount) AS purchase_amount'),
            DB::raw('0 AS total_Sale_amount')
        )
      ->groupBy(DB::raw('YEAR(date), MONTH(date)'));

    // Total petty cash by day
    $pettyCashesQuery = DB::table('petty_cashes')
        ->select(
   DB::raw('YEAR(date) AS year'),
            DB::raw('MONTH(date) AS month'),
            DB::raw('0 AS total_expenses'),
            DB::raw('SUM(amount) AS total_petty_cash'),
            DB::raw('0 AS purchase_amount'),
            DB::raw('0 AS total_Sale_amount')
        )
      ->groupBy(DB::raw('YEAR(date), MONTH(date)'));

    // Combine all using UNION ALL
    $combinedSql = "({$expensesQuery->toSql()})
        UNION ALL
        ({$pettyCashesQuery->toSql()})
        UNION ALL
        ({$purchasePaymentsQuery->toSql()})
        UNION ALL
        ({$salePaymentQuery->toSql()})";

    $combinedQuery = DB::table(DB::raw("({$combinedSql}) as combined"))
        ->mergeBindings($expensesQuery)
        ->mergeBindings($pettyCashesQuery)
        ->mergeBindings($purchasePaymentsQuery)
        ->mergeBindings($salePaymentQuery)
        ->select(
            'year',
            'month',
             DB::raw('CONCAT(year, "-", LPAD(month, 2, "0")) AS yearMonth'),
            DB::raw('SUM(total_expenses) AS total_expenses'),
            DB::raw('SUM(total_petty_cash) AS total_petty_cash'),
            DB::raw('SUM(purchase_amount) AS purchase_amount'),
            DB::raw('SUM(total_Sale_amount) AS total_Sale_amount')
        )
         ->whereNotNull('year')
            ->whereNotNull('month')
            ->groupBy('year', 'month')
            ->orderBy('year')
            ->orderBy('month');

    // Run the query
    $monthlyReport = DB::select($combinedQuery->toSql(), $combinedQuery->getBindings());

    // Convert to collection
    $monthlyReport = collect($monthlyReport);

    // Add cumulative fields
    $cumulativePettyCash = 0;
    $cumulativeExpenses = 0;

    $monthlyReport = $monthlyReport->map(function ($item) use (&$cumulativePettyCash, &$cumulativeExpenses) {
        $cumulativePettyCash += $item->total_petty_cash;
        $cumulativeExpenses += $item->total_expenses;

        $item->total_petty_cash_amount = $cumulativePettyCash;
        $item->total_expenses_amount = $cumulativeExpenses;
        $item->balance = $cumulativePettyCash - $cumulativeExpenses;

        return $item;
    });

    return $monthlyReport;
    }


    public function getBranchReportList()
    {
        // Query for expenses
        // $expenses = DB::table('expenses')
        //     ->leftJoin('branches', 'branches.id', '=', 'expenses.branches_id')
        //     ->select(
        //         'branches.branch_name as BranchName',
        //         DB::raw('SUM(expenses.amount) as total_expenses'),
        //         DB::raw('0 as total_petty_cash')
        //     )
        //     ->groupBy('branches.branch_name');
    
        // // Query for petty cash
        // $petty_cashes = DB::table('petty_cashes')
        //     ->leftJoin('branches', 'branches.id', '=', 'petty_cashes.branch_id')
        //     ->select(
        //         'branches.branch_name as BranchName',
        //         DB::raw('0 as total_expenses'),
        //         DB::raw('SUM(petty_cashes.amount) as total_petty_cash')
        //     )
        //     ->groupBy('branches.branch_name');
    
        // // Combine the queries using UNION ALL
        // $combinedQuery = DB::table(DB::raw("({$expenses->toSql()} UNION ALL {$petty_cashes->toSql()}) as combined"))
        //     ->select(
        //         'BranchName',
        //         DB::raw('SUM(total_expenses) as total_expenses'),
        //         DB::raw('SUM(total_petty_cash) as total_petty_cash')
        //     )
        //     ->groupBy('BranchName')
        //     ->orderBy('BranchName');
    
        // // Bind the parameters to the raw query
        // $bindings = array_merge(
        //     $expenses->getBindings(),
        //     $petty_cashes->getBindings()
        // );
    
        // // Execute the combined query
        // $monthlyReport = DB::select($combinedQuery->toSql(), $bindings);
    
        // return $monthlyReport;




         $expensesQuery = DB::table('expenses')
         ->leftJoin('branches', 'branches.id', '=', 'expenses.branches_id')
        ->select(
    'branches.branch_name as BranchName',
            DB::raw('SUM(amount) AS total_expenses'),
            DB::raw('0 AS total_petty_cash'),
            DB::raw('0 AS purchase_amount'),
            DB::raw('0 AS total_Sale_amount')
        )
        ->groupBy('branches.branch_name');

    // Total sales payments by day
    $salePaymentQuery = DB::table('sales_payments')
    ->leftJoin('sales', 'sales.id', '=', 'sales_payments.sale_id')
    ->leftJoin('branches', 'branches.id', '=', 'sales.branch_id')
        ->select(
    'branches.branch_name as BranchName',
            DB::raw('0 AS total_expenses'),
            DB::raw('0 AS total_petty_cash'),
            DB::raw('0 AS purchase_amount'),
            DB::raw('SUM(amount) AS total_Sale_amount')
        )
        ->groupBy('branches.branch_name');

    // Total purchase payments by day
    $purchasePaymentsQuery = DB::table('purchase_payments')
    ->leftJoin('purchases', 'purchases.id', '=', 'purchase_payments.purchases_id')
    ->leftJoin('branches', 'branches.id', '=', 'purchases.branch_id')
        ->select(
    'branches.branch_name as BranchName',
            DB::raw('0 AS total_expenses'),
            DB::raw('0 AS total_petty_cash'),
            DB::raw('SUM(amount) AS purchase_amount'),
            DB::raw('0 AS total_Sale_amount')
        )
     ->groupBy('branches.branch_name');

    // Total petty cash by day
    $pettyCashesQuery = DB::table('petty_cashes')
    ->leftJoin('branches', 'branches.id', '=', 'petty_cashes.branch_id')
        ->select(
    'branches.branch_name as BranchName',
            DB::raw('0 AS total_expenses'),
            DB::raw('SUM(amount) AS total_petty_cash'),
            DB::raw('0 AS purchase_amount'),
            DB::raw('0 AS total_Sale_amount')
        )
       ->groupBy('branches.branch_name');

    // Combine all using UNION ALL
    $combinedSql = "({$expensesQuery->toSql()})
        UNION ALL
        ({$pettyCashesQuery->toSql()})
        UNION ALL
        ({$purchasePaymentsQuery->toSql()})
        UNION ALL
        ({$salePaymentQuery->toSql()})";

    $combinedQuery = DB::table(DB::raw("({$combinedSql}) as combined"))
        ->mergeBindings($expensesQuery)
        ->mergeBindings($pettyCashesQuery)
        ->mergeBindings($purchasePaymentsQuery)
        ->mergeBindings($salePaymentQuery)
        ->select(
             'BranchName',
            DB::raw('SUM(total_expenses) AS total_expenses'),
            DB::raw('SUM(total_petty_cash) AS total_petty_cash'),
            DB::raw('SUM(purchase_amount) AS purchase_amount'),
            DB::raw('SUM(total_Sale_amount) AS total_Sale_amount')
        )
        ->groupBy('BranchName')
        ->orderBy('BranchName');

    // Run the query
    $monthlyReport = DB::select($combinedQuery->toSql(), $combinedQuery->getBindings());

    // Convert to collection
    $monthlyReport = collect($monthlyReport);

    // Add cumulative fields
    $cumulativePettyCash = 0;
    $cumulativeExpenses = 0;

    $monthlyReport = $monthlyReport->map(function ($item) use (&$cumulativePettyCash, &$cumulativeExpenses) {
        $cumulativePettyCash += $item->total_petty_cash;
        $cumulativeExpenses += $item->total_expenses;

        $item->total_petty_cash_amount = $cumulativePettyCash;
        $item->total_expenses_amount = $cumulativeExpenses;
        $item->balance = $cumulativePettyCash - $cumulativeExpenses;

        return $item;
    });

    return $monthlyReport;
    }
    

    

    public function getAnnualyReportList()
{

     $expensesQuery = DB::table('expenses')
        ->select(
   DB::raw('YEAR(date) AS year'),
            DB::raw('SUM(amount) AS total_expenses'),
            DB::raw('0 AS total_petty_cash'),
            DB::raw('0 AS purchase_amount'),
            DB::raw('0 AS total_Sale_amount')
        )
       ->groupBy(DB::raw('YEAR(date)'));

    // Total sales payments by day
    $salePaymentQuery = DB::table('sales_payments')
        ->select(
   DB::raw('YEAR(date) AS year'),
            DB::raw('0 AS total_expenses'),
            DB::raw('0 AS total_petty_cash'),
            DB::raw('0 AS purchase_amount'),
            DB::raw('SUM(amount) AS total_Sale_amount')
        )
       ->groupBy(DB::raw('YEAR(date)'));

    // Total purchase payments by day
    $purchasePaymentsQuery = DB::table('purchase_payments')
        ->select(
   DB::raw('YEAR(date) AS year'),
            DB::raw('0 AS total_expenses'),
            DB::raw('0 AS total_petty_cash'),
            DB::raw('SUM(amount) AS purchase_amount'),
            DB::raw('0 AS total_Sale_amount')
        )
      ->groupBy(DB::raw('YEAR(date)'));

    // Total petty cash by day
    $pettyCashesQuery = DB::table('petty_cashes')
        ->select(
   DB::raw('YEAR(date) AS year'),
            DB::raw('0 AS total_expenses'),
            DB::raw('SUM(amount) AS total_petty_cash'),
            DB::raw('0 AS purchase_amount'),
            DB::raw('0 AS total_Sale_amount')
        )
      ->groupBy(DB::raw('YEAR(date)'));

    // Combine all using UNION ALL
    $combinedSql = "({$expensesQuery->toSql()})
        UNION ALL
        ({$pettyCashesQuery->toSql()})
        UNION ALL
        ({$purchasePaymentsQuery->toSql()})
        UNION ALL
        ({$salePaymentQuery->toSql()})";

    $combinedQuery = DB::table(DB::raw("({$combinedSql}) as combined"))
        ->mergeBindings($expensesQuery)
        ->mergeBindings($pettyCashesQuery)
        ->mergeBindings($purchasePaymentsQuery)
        ->mergeBindings($salePaymentQuery)
        ->select(
            'year',
            DB::raw('SUM(total_expenses) AS total_expenses'),
            DB::raw('SUM(total_petty_cash) AS total_petty_cash'),
            DB::raw('SUM(purchase_amount) AS purchase_amount'),
            DB::raw('SUM(total_Sale_amount) AS total_Sale_amount')
        )
        ->whereNotNull('year')
        ->orderBy('year')
        ->groupBy('year');

    // Run the query
    $monthlyReport = DB::select($combinedQuery->toSql(), $combinedQuery->getBindings());

    // Convert to collection
    $monthlyReport = collect($monthlyReport);

    // Add cumulative fields
    $cumulativePettyCash = 0;
    $cumulativeExpenses = 0;

    $monthlyReport = $monthlyReport->map(function ($item) use (&$cumulativePettyCash, &$cumulativeExpenses) {
        $cumulativePettyCash += $item->total_petty_cash;
        $cumulativeExpenses += $item->total_expenses;

        $item->total_petty_cash_amount = $cumulativePettyCash;
        $item->total_expenses_amount = $cumulativeExpenses;
        $item->balance = $cumulativePettyCash - $cumulativeExpenses;

        return $item;
    });

    return $monthlyReport;
}


// public function getDailyReportList()
// {
//     // Query for total expenses by day
//     $expensesQuery = DB::table('expenses')
//         ->select(
//             DB::raw('DATE(date) AS date'),
//             DB::raw('SUM(amount) AS total_expenses'),
//             DB::raw('0 AS total_petty_cash')
//         )
//         ->groupBy(DB::raw('DATE(date)'));

//     // Query for total petty cash by day
//     $pettyCashesQuery = DB::table('petty_cashes')
//         ->select(
//             DB::raw('DATE(date) AS date'),
//             DB::raw('0 AS total_expenses'),
//             DB::raw('SUM(amount) AS total_petty_cash')
//         )
//         ->groupBy(DB::raw('DATE(date)'));

//     // Combine queries using UNION ALL
//     $combinedQuery = DB::table(DB::raw("(
//         ({$expensesQuery->toSql()})
//         UNION ALL
//         ({$pettyCashesQuery->toSql()})
//     ) as combined"))
//     ->mergeBindings($expensesQuery) // Ensure bindings are merged correctly
//     ->mergeBindings($pettyCashesQuery)
//     ->select(
//         'date',
//         DB::raw('SUM(total_expenses) as total_expenses'),
//         DB::raw('SUM(total_petty_cash) as total_petty_cash')
//     )
//     ->whereNotNull('date')
//     ->orderBy('date')
//     ->groupBy('date');

//     // Execute the combined query
//     $dailyReport = DB::select($combinedQuery->toSql());

//     return $dailyReport;
// }

public function getDailyReportList()
{
    // Total expenses by day
    $expensesQuery = DB::table('expenses')
        ->select(
            DB::raw('DATE(date) AS date'),
            DB::raw('SUM(amount) AS total_expenses'),
            DB::raw('0 AS total_petty_cash'),
            DB::raw('0 AS purchase_amount'),
            DB::raw('0 AS total_Sale_amount')
        )
        ->groupBy(DB::raw('DATE(date)'));

    // Total sales payments by day
    $salePaymentQuery = DB::table('sales_payments')
        ->select(
            DB::raw('DATE(date) AS date'),
            DB::raw('0 AS total_expenses'),
            DB::raw('0 AS total_petty_cash'),
            DB::raw('0 AS purchase_amount'),
            DB::raw('SUM(amount) AS total_Sale_amount')
        )
        ->groupBy(DB::raw('DATE(date)'));

    // Total purchase payments by day
    $purchasePaymentsQuery = DB::table('purchase_payments')
        ->select(
            DB::raw('DATE(date) AS date'),
            DB::raw('0 AS total_expenses'),
            DB::raw('0 AS total_petty_cash'),
            DB::raw('SUM(amount) AS purchase_amount'),
            DB::raw('0 AS total_Sale_amount')
        )
        ->groupBy(DB::raw('DATE(date)'));

    // Total petty cash by day
    $pettyCashesQuery = DB::table('petty_cashes')
        ->select(
            DB::raw('DATE(date) AS date'),
            DB::raw('0 AS total_expenses'),
            DB::raw('SUM(amount) AS total_petty_cash'),
            DB::raw('0 AS purchase_amount'),
            DB::raw('0 AS total_Sale_amount')
        )
        ->groupBy(DB::raw('DATE(date)'));

    // Combine all using UNION ALL
    $combinedSql = "({$expensesQuery->toSql()})
        UNION ALL
        ({$pettyCashesQuery->toSql()})
        UNION ALL
        ({$purchasePaymentsQuery->toSql()})
        UNION ALL
        ({$salePaymentQuery->toSql()})";

    $combinedQuery = DB::table(DB::raw("({$combinedSql}) as combined"))
        ->mergeBindings($expensesQuery)
        ->mergeBindings($pettyCashesQuery)
        ->mergeBindings($purchasePaymentsQuery)
        ->mergeBindings($salePaymentQuery)
        ->select(
            'date',
            DB::raw('SUM(total_expenses) AS total_expenses'),
            DB::raw('SUM(total_petty_cash) AS total_petty_cash'),
            DB::raw('SUM(purchase_amount) AS purchase_amount'),
            DB::raw('SUM(total_Sale_amount) AS total_Sale_amount')
        )
        ->whereNotNull('date')
        ->groupBy('date')
        ->orderBy('date');

    // Run the query
    $dailyReport = DB::select($combinedQuery->toSql(), $combinedQuery->getBindings());

    // Convert to collection
    $dailyReport = collect($dailyReport);

    // Add cumulative fields
    $cumulativePettyCash = 0;
    $cumulativeExpenses = 0;

    $dailyReport = $dailyReport->map(function ($item) use (&$cumulativePettyCash, &$cumulativeExpenses) {
        $cumulativePettyCash += $item->total_petty_cash;
        $cumulativeExpenses += $item->total_expenses;

        $item->total_petty_cash_amount = $cumulativePettyCash;
        $item->total_expenses_amount = $cumulativeExpenses;
        $item->balance = $cumulativePettyCash - $cumulativeExpenses;

        return $item;
    });

    return $dailyReport;
}


    

public function getDailyReportListByDate($date)
{
    $bindings = [];

    // Dummy query
    $dummySql = "(SELECT DATE(?) AS date, 0 AS total_expenses, 0 AS total_petty_cash, 0 AS purchase_amount, 0 AS total_Sale_amount, 0 AS total_start_cash_registers, 0 AS total_end_cash_registers)";
    $bindings[] = $date;

    // Expenses
    $expensesQuery = DB::table('expenses')
        ->whereDate('expenses.date', $date)
        ->whereRaw("LOWER(expenses.Payment_method) = 'cash'")
        ->selectRaw("DATE(date) AS date, SUM(amount) AS total_expenses, 0 AS total_petty_cash, 0 AS purchase_amount, 0 AS total_Sale_amount, 0 AS total_start_cash_registers, 0 AS total_end_cash_registers")
        ->groupBy(DB::raw('DATE(date)'));

    // Petty Cash
    $pettyQuery = DB::table('petty_cashes')
        ->whereDate('petty_cashes.date', $date)
        ->selectRaw("DATE(date) AS date, 0 AS total_expenses, SUM(amount) AS total_petty_cash, 0 AS purchase_amount, 0 AS total_Sale_amount, 0 AS total_start_cash_registers, 0 AS total_end_cash_registers")
        ->groupBy(DB::raw('DATE(date)'));

    // Purchase Payments
    $purchaseQuery = DB::table('purchase_payments')
        ->whereDate('purchase_payments.date', $date)
        ->whereRaw("LOWER(purchase_payments.method) = 'cash'")
        ->selectRaw("DATE(date) AS date, 0 AS total_expenses, 0 AS total_petty_cash, SUM(amount) AS purchase_amount, 0 AS total_Sale_amount, 0 AS total_start_cash_registers, 0 AS total_end_cash_registers")
        ->groupBy(DB::raw('DATE(date)'));

    // Sales Payments
    $salesQuery = DB::table('sales_payments')
        ->whereDate('sales_payments.date', $date)
        ->whereRaw("LOWER(sales_payments.method) = 'cash'")
        ->selectRaw("DATE(date) AS date, 0 AS total_expenses, 0 AS total_petty_cash, 0 AS purchase_amount, SUM(amount) AS total_Sale_amount, 0 AS total_start_cash_registers, 0 AS total_end_cash_registers")
        ->groupBy(DB::raw('DATE(date)'));

    // Start Cash
    $startCashQuery = DB::table('start_cash_registers')
        ->whereDate('start_cash_registers.date', $date)
        ->selectRaw("DATE(date) AS date, 0 AS total_expenses, 0 AS total_petty_cash, 0 AS purchase_amount, 0 AS total_Sale_amount, SUM(amount) AS total_start_cash_registers, 0 AS total_end_cash_registers")
        ->groupBy(DB::raw('DATE(date)'));

    // End Cash
    $endCashQuery = DB::table('end_cash_registers')
        ->whereDate('end_cash_registers.date', $date)
        ->selectRaw("DATE(date) AS date, 0 AS total_expenses, 0 AS total_petty_cash, 0 AS purchase_amount, 0 AS total_Sale_amount, 0 AS total_start_cash_registers, SUM(amount) AS total_end_cash_registers")
        ->groupBy(DB::raw('DATE(date)'));

    // Get SQL strings from each query
    $queries = [
        $dummySql,
        $expensesQuery->toSql(),
        $pettyQuery->toSql(),
        $purchaseQuery->toSql(),
        $salesQuery->toSql(),
        $startCashQuery->toSql(),
        $endCashQuery->toSql(),
    ];

    // Merge all bindings
    $bindings = array_merge(
        $bindings,
        $expensesQuery->getBindings(),
        $pettyQuery->getBindings(),
        $purchaseQuery->getBindings(),
        $salesQuery->getBindings(),
        $startCashQuery->getBindings(),
        $endCashQuery->getBindings()
    );

    // Final union SQL
    $unionSql = implode(' UNION ALL ', array_map(fn($q) => "($q)", $queries));

    // Final wrapper query
    $finalQuery = DB::table(DB::raw("($unionSql) as combined"))
        ->select(
            'date',
            DB::raw('SUM(total_expenses) AS total_expenses'),
            DB::raw('SUM(total_petty_cash) AS total_petty_cash'),
            DB::raw('SUM(purchase_amount) AS purchase_amount'),
            DB::raw('SUM(total_Sale_amount) AS total_Sale_amount'),
            DB::raw('SUM(total_start_cash_registers) AS total_start_cash_registers'),
            DB::raw('SUM(total_end_cash_registers) AS total_end_cash_registers')
        )
        ->groupBy('date')
        ->orderBy('date');

    $results = DB::select($finalQuery->toSql(), $bindings);

    // Convert to collection and calculate running totals
    $collection = collect($results);
    $cumulativePetty = 0;
    $cumulativeExpenses = 0;

    $collection = $collection->map(function ($item) use (&$cumulativePetty, &$cumulativeExpenses) {
        $cumulativePetty += $item->total_petty_cash;
        $cumulativeExpenses += $item->total_expenses;
        $item->total_petty_cash_amount = $cumulativePetty;
        $item->total_expenses_amount = $cumulativeExpenses;
        $item->balance = $cumulativePetty - $cumulativeExpenses;
        return $item;
    });

    return $collection;
}




    public function getMonthlyReportData(Request $request)
    {
        $date = $request->input('date');
        $yearMonth = date('Y.m', strtotime($date));
        $receiedAmount =  DB::table('expenses')
        ->leftJoin('branches', 'expenses.branches_id', '=', 'branches.id')
        ->leftJoin('expenses_sub_categories','expenses.sub_expenses_category_id','=','expenses_sub_categories.id')
        ->leftJoin('expenses_categories','expenses_sub_categories.expenses_category_id','=','expenses_categories.id')
        ->select('expenses.*','expenses_sub_categories.expenses_sub_category','expenses_categories.expenses_category','branches.branch_name')
        ->whereRaw("DATE_FORMAT(expenses.date, '%Y.%m') = ?", [$yearMonth])
        // ->whereIn('customers_installations.status', [1, 2])
        ->get();
     
        $response['data'] = $receiedAmount;
        return response()->json($response);

    }

    public function getBranchEachData(Request $request)
    {
        $branch = $request->input('branch');
   
        // $Branch_Details = Branches::where('branch_name', $branch)->first();
        // $Branch_Id =$Branch_Details->id;
        

        $receiedAmount =  DB::table('expenses')
        ->leftJoin('branches', 'expenses.branches_id', '=', 'branches.id')
        ->leftJoin('expenses_sub_categories','expenses.sub_expenses_category_id','=','expenses_sub_categories.id')
        ->leftJoin('expenses_categories','expenses_sub_categories.expenses_category_id','=','expenses_categories.id')
        ->select('expenses.*','expenses_sub_categories.expenses_sub_category','expenses_categories.expenses_category','branches.branch_name')
        ->where("branches.branch_name", $branch)
        // ->whereIn('customers_installations.status', [1, 2])
        ->get();
     
        $response['data'] = $receiedAmount;
        return response()->json($response);

    }

    
    public function getMonthlyTopupData(Request $request)
    {
        $date = $request->input('date');
        $yearMonth = date('Y.m', strtotime($date));
        $petty_cashes =  DB::table('petty_cashes')->whereRaw("DATE_FORMAT(petty_cashes.date, '%Y.%m') = ?", [$yearMonth])
        // ->whereIn('customers_installations.status', [1, 2])
        ->get();
     
        $response['data'] = $petty_cashes;
      
        return response()->json($response);

    }

    public function getAnnualyReportData(Request $request)
    {
        $date = $request->input('date');
        $year = date('Y', strtotime($date));
        $receiedAmount =  DB::table('expenses')
        ->leftJoin('branches', 'expenses.branches_id', '=', 'branches.id')
        ->leftJoin('expenses_sub_categories','expenses.sub_expenses_category_id','=','expenses_sub_categories.id')
        ->leftJoin('expenses_categories','expenses_sub_categories.expenses_category_id','=','expenses_categories.id')
        ->select('expenses.*','expenses_sub_categories.expenses_sub_category','expenses_categories.expenses_category','branches.branch_name')
        ->whereRaw("DATE_FORMAT(expenses.date, '%Y') = ?", [$year])
        // ->whereIn('customers_installations.status', [1, 2])
        ->get();
     
        $response['data'] = $receiedAmount;
        return response()->json($response);

    }
    public function getAnnualyTopupData(Request $request)
    {
        $date = $request->input('date');
        $year = date('Y', strtotime($date));
        $petty_cashes =  DB::table('petty_cashes')->whereRaw("DATE_FORMAT(petty_cashes.date, '%Y') = ?", [$year])
        // ->whereIn('customers_installations.status', [1, 2])
        ->get();
     
        $response['data'] = $petty_cashes;
      
        return response()->json($response);

    }
    
    public function getDailyTopupData(Request $request)
    {
        $date = $request->input('date');
    
    // Query petty cash entries for the specific date
    $pettyCashes = DB::table('petty_cashes')
        ->whereDate('date', '=', $date)
        ->get();
     
    // Prepare the response data
    $response['data'] = $pettyCashes;
      
    // Return the response as JSON
    return response()->json($response);
    }


    public function getDailyReportData(Request $request)
{
    // Get the date from the request
    $date = $request->input('date');
    
    // Query expenses for the specific date
    $receivedAmount = DB::table('expenses')
        ->leftJoin('branches', 'expenses.branches_id', '=', 'branches.id')
        ->leftJoin('expenses_sub_categories', 'expenses.sub_expenses_category_id', '=', 'expenses_sub_categories.id')
        ->leftJoin('expenses_categories', 'expenses_sub_categories.expenses_category_id', '=', 'expenses_categories.id')
        ->select('expenses.*', 'expenses_sub_categories.expenses_sub_category', 'expenses_categories.expenses_category', 'branches.branch_name')
        ->whereDate('expenses.date', '=', $date)
        ->get();
     
    // Prepare the response data
    $response['data'] = $receivedAmount;
    
    // Return the response as JSON
    return response()->json($response);
}

    
}