<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('expenses_sub_categories', function (Blueprint $table) {
            $table->id();
            $table->string('expenses_sub_category');
            $table->unsignedBigInteger('expenses_category_id');
            $table->text('description')->nullable();
            $table->foreign('expenses_category_id')->references('id')->on('expenses_categories')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('expenses_sub_categories');
    }
};
