<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_items', function (Blueprint $table) {
                $table->id();
                $table->string('item_name');
                $table->string('item_quantity');
                $table->decimal('price', 25,2);
                $table->unsignedBigInteger('expenses_id');
                $table->foreign('expenses_id')->references('id')->on('expenses')->onDelete('cascade'); 
                $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_items');
    }
};
