<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_products_badgstock', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('product_id');
            $table->unsignedBigInteger('purchases_id')->nullable();
            $table->decimal('quantity', 10);
            $table->decimal('total_cost', 10, 2);
            $table->decimal('each_cost', 10, 2);
            $table->decimal('price', 10, 2);
            $table->decimal('sale_quantity', 10)->default(0);
             $table->unsignedBigInteger('branches_id')->nullable();
            $table->foreign('branches_id')->references('id')->on('branches')->onDelete('cascade');
            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
            $table->foreign('purchases_id')->references('id')->on('purchases');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_products');
    }
};
