<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('return_product_items', function (Blueprint $table) {
            $table->id();
            $table->string(column: 'imu_number')->unique();
            $table->unsignedBigInteger('return_products_id');
            $table->decimal('quantity', 10);
            $table->decimal('each_cost', 10, 2);
            $table->foreign('return_products_id')->references('id')->on('return_products');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('return_product_items');
    }
};
