<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales', function (Blueprint $table) {
            $table->id();
            $table->string(column: 'sale_reference')->unique();
            $table->string(column: 'sale_type');
            $table->string(column: 'nick_name')->nullable();
            $table->date(column: 'date');
            $table->unsignedBigInteger('customer_id');
            $table->unsignedBigInteger('branch_id');
            $table->decimal('total_price', 25, 2);
            $table->decimal('total_cost', 25, 2);
            $table->decimal('quantity', 15);
            $table->decimal('discount_amount', 10, 2)->nullable();
            $table->decimal('discount_prasentage', 10, 2)->nullable();
            $table->decimal('service_charge', 25, 2)->nullable();
            $table->decimal('tax_charge', 25, 2)->nullable();
            $table->decimal('other_charge', 25, 2)->nullable();
            $table->decimal('total_other_charge', 25, 2)->nullable();
            $table->decimal('received_amount', 25, 2);
            $table->decimal('outstanding_amount', 25, 2);
            $table->text('other_charge_description')->nullable(); 
            $table->decimal('final_total_price', 25, 2);
            $table->foreign('customer_id')->references('id')->on('people');
            $table->foreign('branch_id')->references('id')->on('branches');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales');
    }
};
