<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sale_products', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('product_id');
            $table->unsignedBigInteger('sale_id');
            $table->unsignedBigInteger('badgstock_id');
            $table->string('type');
            $table->decimal('quantity', 10);
            $table->decimal('cost', 25, 2);
            $table->decimal('price', 25, 2);
            $table->decimal('profit', 25, 2);
            $table->string('warranty_status')->nullable(); 
            $table->string('warranty_period')->nullable(); 
            $table->foreign('badgstock_id')->references('id')->on('purchase_products_badgstock');
            $table->foreign('sale_id')->references('id')->on('sales');
            $table->foreign('product_id')->references('id')->on('products');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sale_products');
    }
};
