<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sale_returns', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('sale_id')->nullable();
            $table->unsignedBigInteger('product_id');
            $table->unsignedBigInteger('badgstock_id');
            $table->date(column: 'date');
            $table->string('type');
            $table->string('name');
            $table->string('code');
            $table->string(column: 'Retun_type'); 
            $table->decimal('quantity', 10);
            $table->decimal('total_price', 10,2);
            $table->decimal('total_cost', 10,2);
            $table->foreign('sale_id')->references('id')->on('sales');
            $table->foreign('product_id')->references('id')->on('products');
            $table->foreign('badgstock_id')->references('id')->on('purchase_products_badgstock');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sale_returns');
    }
};
