<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_transfers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('product_id');
            $table->decimal('quantity', 10);
            $table->date('date');
            $table->unsignedBigInteger('from_branches_id');
            $table->unsignedBigInteger('to_branches_id');
            $table->foreign('product_id')->references('id')->on('products');
            $table->foreign('to_branches_id')->references('id')->on('branches')->onDelete('cascade');
            $table->foreign('from_branches_id')->references('id')->on('branches')->onDelete('cascade'); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_transfers');
    }
};
