@extends('layouts.app')
@section('content')
<style>
  button.dt-button, div.dt-button, a.dt-button, input.dt-button {
    border-radius: 5px;
    color: white;
    background-color: rgb(197, 7, 178);
    box-shadow: rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset;
}

button.dt-button:hover:not(.disabled), div.dt-button:hover:not(.disabled), a.dt-button:hover:not(.disabled), input.dt-button:hover:not(.disabled) {
    border: 1px solid #666;
    background-color: rgb(29, 29, 29);
}

.button-34 {
  background: #5E5DF0;
  border-radius: 999px;
  box-shadow: #5E5DF0 0 10px 20px -10px;
  box-sizing: border-box;
  color: #FFFFFF;
  cursor: pointer;
  font-family: Inter,Helvetica,"Apple Color Emoji","Segoe UI Emoji",NotoColorEmoji,"Noto Color Emoji","Segoe UI Symbol","Android Emoji",EmojiSymbols,-apple-system,system-ui,"Segoe UI",Roboto,"Helvetica Neue","Noto Sans",sans-serif;
  font-size: 16px;
  font-weight: 700;
  line-height: 24px;
  opacity: 1;
  outline: 0 solid transparent;
  padding: 8px 18px;
  user-select: none;
  -webkit-user-select: none;
  touch-action: manipulation;
  width: fit-content;
  word-break: break-word;
  border: 0;
}

.btn5{
  background: #670479;
  border-radius: 999px;
  box-shadow: #eb5df0 0 10px 20px -10px;  
}
</style>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="page-header">
            <h3 class="page-title">
              Sale Reference : {{$sale->sale_reference }}
            </h3>
          </div>
          <div class="row grid-margin">
            <div class="col-12">
              <div class="card card-statistics">
                <div class="card-body">
                  <div class="d-flex flex-column flex-md-row align-items-center justify-content-between">
                    <div class="statistics-item">
                        <p>
                            <i class="icon-sm fa fa-user mr-2"></i>
                            Customer
                        </p>
                        <h5>{{$sale->name }}</h5>
                    </div>
                   
                    <div class="statistics-item">
                        <p>
                            <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                            Received Amount
                        </p>
                        <h5>{{ number_format($sale->received_amount, 2) }}</h5>
                    </div>
                    <div class="statistics-item">
                      <p>
                          <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                          Total Cost
                      </p>
                      <h5>{{ number_format($sale->total_cost, 2) }}</h5>
                  </div>
                    <div class="statistics-item">
                        <p>
                            <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                            Total Quantity
                        </p>
                        <h5>{{ $sale->quantity }}</h5>
                        {{-- <h4>{{ number_format($purchaseTotalSums->overall_total_cost - $purchaseTotalSums->overall_total_paid, 2) }}</h4>
                   
                        @if (($purchaseTotalSums->overall_total_cost - $purchaseTotalSums->overall_total_paid) > 0)
                            <label class="badge badge-outline-danger badge-pill">Outstanding Amount</label>
                        @else
                            <label class="badge badge-outline-success badge-pill">Balance Amount</label>
                        @endif --}}
                    </div>
                   
                    
                      
                  </div>
                 
                  <hr>
                  <div class="d-flex flex-column flex-md-row align-items-center justify-content-between">
                    <div class="statistics-item">
                        <p>
                            <i class="icon-sm fa fa-user mr-2"></i>
                            Other Charges
                        </p>
                        <h5>{{$sale->total_other_charge }}</h5>
                    </div>
                   
                    <div class="statistics-item">
                      @if(!is_null($sale->discount_amount) && $sale->discount_amount > 0)
                      <p>
                          <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                          Discount Amount
                      </p>
                      <h5>{{ $sale->discount_amount }}</h5> <!-- Should be discount_amount -->
                  @elseif(!is_null($sale->discount_percentage) && $sale->discount_percentage > 0)
                      <p>
                          <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                          Discount Percentage
                      </p>
                      <h5>{{ $sale->discount_percentage }}%</h5>
                  @else
                  <p>
                    <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                    No Discount
                </p>
                  @endif
                  
                    </div>
                    <div class="statistics-item">
                      <p>
                          <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                          Total Price
                      </p>
                      <h5>{{ number_format($sale->final_total_price, 2) }}</h5>
                      {{-- <label class="badge badge-outline-success badge-pill">Received Amount : {{ number_format($sale->received_amount, 2) }}</label> --}}
                  </div>
                    <div class="statistics-item">
                        <p>
                            <i class="icon-sm fas fa-hourglass-half mr-2"></i>
                            Total Profit
                        </p>
                        {{-- <h4>{{ number_format($sale->total_price, 2) }}</h4> --}}
                        <h5>{{ number_format($sale->received_amount - $sale->total_cost, 2) }}</h5>
                   
                        {{-- @if (($purchaseTotalSums->overall_total_cost - $purchaseTotalSums->overall_total_paid) > 0)
                            <label class="badge badge-outline-danger badge-pill">Outstanding Amount</label>
                        @else
                            <label class="badge badge-outline-success badge-pill">Balance Amount</label>
                        @endif --}}
                    </div>
                   
                    
                      
                  </div>
                </div>
              </div>
            </div>
          </div>
                <div class="col-md-12 grid-margin stretch-card">
                    
              <div class="card">
                <div class="card-body">
                  {{-- <h4 class="card-title">Pills</h4>
                  <p class="card-description">Basic nav pills</p> --}}
                  <ul class="nav nav-pills nav-pills-success" id="pills-tab" role="tablist">
                    <li class="nav-item">
                      <a class="nav-link active" id="pills-home-tab" data-toggle="pill" href="#pills-home" role="tab" aria-controls="pills-home" aria-selected="true">PRODUCTS</a>
                    </li>
                    <li class="nav-item">
                      <a class="nav-link" id="pills-profile-tab" data-toggle="pill" href="#pills-profile" role="tab" aria-controls="pills-profile" aria-selected="false">ITEMS</a>
                    </li>
                    <div style="position: relative; width: 100%; position:relative; top:-50px">
                      <button class="button-34 return" data-id="{{ $sale->id }}" role="button" style="position: absolute; top: 0; right: 120px;">
                          Return Items
                      </button>
                      <button class="button-34 btn5 edit" data-id="{{ $sale->id }}" role="button" style="position: absolute; top: 0; right: 0;">
                          Edit Items
                      </button>
                  </div>
                  
                  
                    
                  </ul>
                 
                  <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">
                      <div class="media">
                        <div class="table-responsive" style="overflow-x: auto; -webkit-overflow-x: auto;">
                            @if($saleProduct->isNotEmpty())
    <table id="example" class="table table-striped table-hover table-product nowrap" style="width: 100%;">
        <thead>
            <tr>
                <th>Id #</th>
                <th>Product Name</th>
                <th>Total <br> Quantity</th>
                <th>Total Cost</th>
                <th>Total Paid</th>
                <th>Profit</th>
                <th>Warranty <br> Period</th>
                <th>Days Left</th> <!-- Added a new column for warranty days left -->
                {{-- <th>Delete</th> --}}
            </tr>
        </thead>
        <tbody>
            @foreach($saleProduct as $sale)
                <tr>
                    <td>{{ $sale->id }}</td>
                    <td>{{ $sale->product_name }}</td>
                    <td>{{ $sale->quantity }}</td>
                    <td>{{ number_format($sale->cost, 2) }}</td>
                    <td>{{ number_format($sale->price, 2) }}</td>
                    <td>{{ number_format($sale->profit, 2) }}</td>
                    <td>{{ $sale->warranty_period }}</td>

                    <!-- Calculate warranty days left -->
                    <td>
                        @if($sale->warranty_status == 'yes')
                            @php
                                $warranty_end_date = null;

                                switch ($sale->warranty_period) {
                                    case '01 Month':
                                        $warranty_end_date = \Carbon\Carbon::parse($sale->date)->addMonth();
                                        break;
                                    case '03 Months':
                                        $warranty_end_date = \Carbon\Carbon::parse($sale->date)->addMonths(3);
                                        break;
                                    case '06 Months':
                                        $warranty_end_date = \Carbon\Carbon::parse($sale->date)->addMonths(6);
                                        break;
                                    case '01 Year':
                                        $warranty_end_date = \Carbon\Carbon::parse($sale->date)->addYear();
                                        break;
                                }

                                $days_left = $warranty_end_date ? now()->diffInDays($warranty_end_date, false) : 0;
                            @endphp

                            {{ $days_left > 0 ? "$days_left days left" : 'Warranty expired' }}
                        @else
                            -
                        @endif
                    </td>

                    <!-- Delete button -->
                    {{-- <td> --}}
                        {{-- Uncomment below if delete functionality is needed --}}
                        {{-- 
                        <form action="{{ route('sales.destroy', $sale->id) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                        </form> 
                        --}}
                    {{-- </td> --}}
                </tr>
            @endforeach
        </tbody>
    </table>
@endif

                            
                        </div>
                      </div>
                    </div>
                    <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                        <table id="example2" class="table table-striped table-hover table-product nowrap" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th>Id #</th>
                                    <th>Product Name</th>
                                    <th>Total <br> Quantity</th>
                                    <th>Total Cost</th>
                                    <th>Total Paid</th>
                                    <th>Profit</th>
                                    <th>Warranty <br> Period</th>
                                    <th>Days Left</th> <!-- Added a new column for warranty days left -->
                                 
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($saleItem as $item)
                                    <tr>
                                        <td>{{ $item->id }}</td>
                                        <td>{{ $item->product_name }}</td>
                                        <td>{{ $item->imu_number  ?? 'N/A' }}</td> <!-- Fixed: Added Total Quantity -->
                                        <td>{{ number_format($item->cost, 2) }}</td>
                                        <td>{{ number_format($item->price, 2) }}</td>
                                        <td>{{ number_format($item->price - $item->cost, 2) }}</td>
                                        <td>{{ $item->warranty_period ?? 'N/A' }}</td>
                                       

                                        <td>
                                          @if($item->warranty_status == 'yes')
                                              @php
                                                  $warranty_end_date = null;
                  
                                                  switch ($item->warranty_period) {
                                                      case '01 Month':
                                                          $warranty_end_date = \Carbon\Carbon::parse($item->date)->addMonth();
                                                          break;
                                                      case '03 Months':
                                                          $warranty_end_date = \Carbon\Carbon::parse($item->date)->addMonths(3);
                                                          break;
                                                      case '06 Months':
                                                          $warranty_end_date = \Carbon\Carbon::parse($item->date)->addMonths(6);
                                                          break;
                                                      case '01 Year':
                                                          $warranty_end_date = \Carbon\Carbon::parse($item->date)->addYear();
                                                          break;
                                                  }
                  
                                                  $days_left = $warranty_end_date ? now()->diffInDays($warranty_end_date, false) : 0;
                                              @endphp
                  
                                              {{ $days_left > 0 ? "$days_left days left" : 'Warranty expired' }}
                                          @else
                                              -
                                          @endif
                                      </td>
                                       
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        
                    </div>
                    
                  </div>
                </div>
              </div>
            </div>
       
         
          <div class="content-wrapper">
            {{-- <div class="page-header">
              <h3 class="page-title">
                Data table
              </h3>
              <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                  <li class="breadcrumb-item"><a href="#">Tables</a></li>
                  <li class="breadcrumb-item active" aria-current="page">Data table</li>
                </ol>
              </nav>
            </div> --}}
            {{-- <div class="card">
              <div class="card-body">
                <h4 class="card-title">Data table</h4>
                <div class="row">
                  <div class="col-12">
                    <div class="table-responsive" style="overflow-x: auto; -webkit-overflow-x: auto;">
                        <table id="example" class="table table-striped table-hover table-product  nowrap" style="width: 100%; ">
                        <thead>
                          <tr>
                              <th>Id #</th>
                              <th>Sale Id</th>
                              <th>Date</th>
                              <th>Supplier</th>
                              <th>total Quantity</th>
                              <th>total Cost</th>
                              <th>total Paid</th>
                              <th>Profit</th>
                              <th>Profit</th>
                              <th>Delete</th>
                          </tr>
                        </thead>
                        <tbody>
                         
                      
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div> --}}
          </div>
          <div class="row">
            <div class="col-12">
              <div class="card">
                <div class="card-body">
                  <div class="d-md-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-facebook btn-rounded">
                        <i class="fab fa-facebook-f"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Facebook</h5>
                        <p class="mb-0">813 friends</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-twitter btn-rounded">
                        <i class="fab fa-twitter"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Twitter</h5>
                        <p class="mb-0">9000 followers</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-google btn-rounded">
                        <i class="fab fa-google-plus-g"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Google plus</h5>
                        <p class="mb-0">780 friends</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center">
                      <button class="btn btn-social-icon btn-linkedin btn-rounded">
                        <i class="fab fa-linkedin-in"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Linkedin</h5>
                        <p class="mb-0">1090 connections</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

      
        <!-- content-wrapper ends -->
        <!-- partial:../../partials/_footer.html -->
        <footer class="footer">
          <div class="d-sm-flex justify-content-center justify-content-sm-between">
            <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">Copyright © 2025  <a href="https://www.urbanui.com/" target="_blank">Urbanui</a>. All rights reserved.</span>
            <span class="float-none float-sm-right d-block mt-1 mt-sm-0 text-center">Hand-crafted & made with <i class="far fa-heart text-danger"></i></span>
          </div>
        </footer>
        <!-- partial -->
      </div>
   
     
      <script>
$( document ).ready(function() {



  $(document).on('click', '.edit', function() {
            var id = $(this).data('id');
            
       
            var url = '/edit_sale_data?id=' + id;
            window.location.href = url;
        });


        $(document).on('click', '.return', function() {
            var id = $(this).data('id');
            
       
            var url = '/return_sale_data?id=' + id;
            window.location.href = url;
        });




  var branch_id = {{ Session::get('branch_id') }} 

  

  // alert("hi")
  $('#example').DataTable({
            dom: "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            processing: true,
            info: true,
            responsive: true,
            lengthMenu: [
                [10, 25, 50, 100, 200, -1],
                [10, 25, 50, 100, 200, "All"]
            ],
       
            createdRow: function(row, data, dataIndex) {
            // Example condition to change font color
            // Adjust condition as needed
                $(row).css('font-size', '15px');
           
        }
        });


        $('#example2').DataTable({
            dom: "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            processing: true,
            info: true,
            responsive: true,
            lengthMenu: [
                [10, 25, 50, 100, 200, -1],
                [10, 25, 50, 100, 200, "All"]
            ],
       
            createdRow: function(row, data, dataIndex) {
            // Example condition to change font color
            // Adjust condition as needed
                $(row).css('font-size', '15px');
           
        }
        });

        $(document).on('click', '.delete', function() {
        var id = $(this).data('id');
        alert(id)

            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger'
                },
                buttonsStyling: false
            })

            swalWithBootstrapButtons.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, Do it!',
                cancelButtonText: 'No, cancel!',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "/delete-expenses",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        type: "POST",
                        data: JSON.stringify({
                            'id': id
                        }),
                        contentType: "application/json",
                        success: function(response) {
                            window.location.reload();
                        },
                    });
                    swalWithBootstrapButtons.fire(
                        'Payment Deleted!',
                        'Your Payment has been Deleted.',
                        'success'
                    )
                } else if (
                    /* Read more about handling dismissals below */
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'Cancelled',
                        'Your imaginary file is safe  😇 ',
                        'error'
                    )
                }
            })

        });

        var ExpensesId;
        $(document).on('click', '.request', function() {
          ExpensesId = $(this).data('id');
         
        });
        $(document).on('click', '.RequestDelete', function() {
        var id = ExpensesId;
        var DeleteReason = $('#DeleteReason').val();

            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger'
                },
                buttonsStyling: false
            })

            swalWithBootstrapButtons.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, Do it!',
                cancelButtonText: 'No, cancel!',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "/Request-delete-expenses",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        type: "POST",
                        data: JSON.stringify({
                            'id': id,
                            'DeleteReason':DeleteReason
                        }),
                        contentType: "application/json",
                        success: function(response) {
                            window.location.reload();
                        },
                    });
                    swalWithBootstrapButtons.fire(
                        'Payment Deleted!',
                        'Your Payment has been Deleted.',
                        'success'
                    )
                } else if (
                    /* Read more about handling dismissals below */
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'Cancelled',
                        'Your imaginary file is safe  😇 ',
                        'error'
                    )
                }
            })

        });


        

        $(document).on('click', '.view', function() {
            var id = $(this).data('id');
            alert(id)

            var url = '/edit_sale_data?id=' + id;
            window.location.href = url;
        });
});
      
      </script>
@endsection
      <!-- main-panel ends -->
    <!-- HTML !-->



