<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BusinessManage\branchController;
use App\Http\Controllers\CashManage\pettyCashController;
use App\Http\Controllers\CashManage\expensesController;
use App\Http\Controllers\Report\reportController;
use App\Http\Controllers\SaleSetting\productbrandController;
use App\Http\Controllers\SaleSetting\customerController;
use App\Http\Controllers\SaleSetting\supplierController;
use App\Http\Controllers\SaleSetting\productCategoryController;
use App\Http\Controllers\Product\productController;
use App\Http\Controllers\Purchase\PurchaseController; 
use App\Http\Controllers\Auth\LoginController; 
use App\Http\Controllers\POS\POSController;
use App\Http\Controllers\POS\saleController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('welcome')->middleware('isLoggedIn');


Route::get('/branch-register-before', [branchController::class, 'branchBeforeUserRegistration'])->name('branch-register-before');
Route::post('/branch-register-before', [BranchController::class, 'store'])->name('branch-register-before.store');
Route::get('/add-Petty-Cash', [pettyCashController::class, 'addPettyCash'])->name('add-Petty-Cash');
Route::get('/logout-user', [LoginController::class, 'logout'])->name('logout-user');
Route::post('/update.branch', [BranchController::class, 'updateBranch'])->name('update.branch');



Auth::routes();

// Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/petty-cash-category', [pettyCashController::class, 'pettyCashCategory'])->name('petty-cash-category')->middleware('isLoggedIn');
Route::get('/petty-cash-sub-category', [pettyCashController::class, 'pettyCashSubCategory'])->name('petty-cash-sub-category')->middleware('isLoggedIn');
Route::get('/add-expenses-page', [expensesController::class, 'addExpensesPage'])->name('add-expenses-page')->middleware('isLoggedIn');
Route::get('/list-expenses-page', [expensesController::class, 'listExpensesPage'])->name('list-expenses-page')->middleware('isLoggedIn');
Route::get('/get-monthly-report', [reportController::class, 'getMonthlyReport'])->name('get-monthly-report')->middleware('isLoggedIn');
Route::get('/get-annualy-report', [reportController::class, 'getAnnualyReport'])->name('get-annualy-report')->middleware('isLoggedIn');
Route::get('/get-daily-report', [reportController::class, 'getDailyReport'])->name('get-daily-report')->middleware('isLoggedIn');
Route::get('/get-branch-report', [reportController::class, 'getBranchReport'])->name('get-branch-report')->middleware('isLoggedIn');
Route::get('/monthly-report-data', [reportController::class, 'monthlyReportData'])->name('monthly-report-data')->middleware('isLoggedIn');
Route::get('/annualy-report-data', [reportController::class, 'annualyReportData'])->name('annualy-report-data')->middleware('isLoggedIn');
Route::get('/daily-report-data', [reportController::class, 'dailyReportData'])->name('daily-report-data')->middleware('isLoggedIn');
Route::get('/branch-report-data', [reportController::class, 'branchReportData'])->name('branch-report-data')->middleware('isLoggedIn');

Route::get('/product-category', [productCategoryController::class, 'productCategory'])->name('product-category')->middleware('isLoggedIn');
Route::get('/product-sub-category', [productCategoryController::class, 'productSubCategory'])->name('product-sub-category')->middleware('isLoggedIn');
Route::get('/product-brand', [productbrandController::class, 'productBrand'])->name('product-brand')->middleware('isLoggedIn');

Route::get('/supplier-register', [supplierController::class, 'supplierRregister'])->name('supplier-register')->middleware('isLoggedIn');
Route::get('/customer-register', [customerController::class, 'customerRregister'])->name('customer-register')->middleware('isLoggedIn');

Route::get('/add-product', [productController::class, 'addProduct'])->name('add-product')->middleware('isLoggedIn');

Route::get('/Bar-code', [productController::class, 'BarCode'])->name('Bar-code')->middleware('isLoggedIn');


Route::get('/quantity_adjustment', [productController::class, 'quantityAdjustment'])->name('quantity_adjustment')->middleware('isLoggedIn');



Route::get('/list-product', [productController::class, 'listProduct'])->name('list-product')->middleware('isLoggedIn');

Route::get('/list-product-branches', [productController::class, 'listProductBranches'])->name('list-product-branches')->middleware('isLoggedIn');

Route::get('/purchase-list', [PurchaseController::class, 'listPurchase'])->name('purchase-list')->middleware('isLoggedIn');

Route::get('/pos-interface', [POSController::class, 'index'])->name('pos-interface')->middleware('isLoggedIn');
Route::get('/pos-interface2', [POSController::class, 'index2'])->name('pos-interface2')->middleware('isLoggedIn');
Route::get('/pos-interface3', [POSController::class, 'index3'])->name('pos-interface3')->middleware('isLoggedIn');

Route::get('/sale-list', [saleController::class, 'saleList'])->name('sale-list')->middleware('isLoggedIn');


Route::get('/return-product', [productController::class, 'returnProduct'])->name('return-product')->middleware('isLoggedIn');




Route::get('/edit-purchace-product', [PurchaseController::class, 'editPurchaceProduct'])->name('edit-purchace-product')->middleware('isLoggedIn');
Route::POST('/update-product-item', [productController::class, 'updateProductItem'])->name('update-product-item');



Route::get('/return-purchace-product', [PurchaseController::class, 'returnPurchaceProduct'])->name('return-purchace-product')->middleware('isLoggedIn');
Route::get('/search-product-for-return/{id}', [PurchaseController::class, 'searchProductForReturn'])->name('search.product.for.return');

Route::get('/search-sale-product-for-return/{id}', [saleController::class, 'searchProductForReturn'])->name('search-sale-product-for-return');
Route::get('/search-product-for-transfer/{id}', [saleController::class, 'searchProductForTransfer'])->name('search-product-for-transfer');



Route::get('/search-productitems-for-return/{id}', [PurchaseController::class, 'searchProductItemsForReturn'])->name('search.productitems.for.return');

Route::get('/search-productitems', [POSController::class, 'searchProductItems'])->name('search.productitems');

Route::get('/search-products', [POSController::class, 'searchProducts'])->name('search-products');

Route::get('/search-product', [productController::class, 'searchProduct']);



Route::get('/purchase-product', [PurchaseController::class, 'purchaseProduct'])->name('purchase-product')->middleware('isLoggedIn');

Route::get('/purchase-grn', [PurchaseController::class, 'purchasegrn'])->name('purchase-grn')->middleware('isLoggedIn');



Route::get('/Delete-Requested-Expenses', [expensesController::class, 'DeleteRequestedExpenses'])->name('Delete-Requested-Expenses');


Route::get('/branch-register', [App\Http\Controllers\HomeController::class, 'branchRegister'])->name('branch-register');
Route::get('/user-register', [App\Http\Controllers\HomeController::class, 'userRegister'])->name('user-register');
Route::post('/edit-user-status', [App\Http\Controllers\HomeController::class, 'editStatus'])->name('edit-user-status');

Route::post('/update.user', [App\Http\Controllers\HomeController::class, 'userUpdate'])->name('update.user');



Route::post('/store.Category', [pettyCashController::class, 'storeCategory'])->name('store.Category');
Route::post('/store-product', [productController::class, 'storeProduct'])->name('store-product');
Route::post('/update-product', [productController::class, 'updateProduct'])->name('update-product');
Route::post('/delete-product', [productController::class, 'deleteProduct'])->name('delete-product');


Route::post('/product_qyt_adjustment', [productController::class, 'productQytAdjustment'])->name('product_qyt_adjustment');


Route::post('/store.Sub.Category', [pettyCashController::class, 'storeSubCategory'])->name('store.Sub.Category');

Route::post('/store-petty-cash', [pettyCashController::class, 'storePettyCash'])->name('store-petty-cash');
Route::post('/store-expenses', [expensesController::class, 'storeExpenses'])->name('store-expenses');


Route::post('/get-expenses-sub-categories', [expensesController::class, 'getExpensesSubCategory'])->name('get-expenses-sub-categories');
Route::post('/get-product-sub-categories', [productCategoryController::class, 'getProductSubCategory'])->name('get-product-sub-categories');



Route::get('/list_product_category', [productCategoryController::class, 'listProductCategory'])->name('list_product_category');

Route::get('/list_product_sub_category', [productCategoryController::class, 'listProductSubCategory'])->name('list_product_sub_category');

Route::get('/list_product_brand', [productbrandController::class, 'listProductBrand'])->name('list_product_brand');

Route::get('/list_suppliers', [supplierController::class, 'listSuppliers'])->name('list_suppliers');
Route::get('/list_costomer', [customerController::class, 'listCostomer'])->name('list_costomer');


Route::get('/list_purchase', [PurchaseController::class, 'Purchaselist'])->name('list_purchase');

Route::get('/list_purchase_by_date/{date}', [PurchaseController::class, 'PurchaselistByDate'])->name('list_purchase_by_date');


Route::get('/purchase_order', [PurchaseController::class, 'purchaseOrder'])->name('purchase_order');
Route::get('/purchase_order_list', [PurchaseController::class, 'PurchaseOrderlist'])->name('purchase_order_list');

Route::get('/list_product', [productController::class, 'Productlist'])->name('list_product');
Route::get('/list_product_branch', [productController::class, 'ProductlistBranch'])->name('list_product_branch');


Route::get('/product_data', [productController::class, 'ProductData'])->name('product_data');
Route::get('/product_branch_data', [productController::class, 'ProductBranchData'])->name('product_branch_data');


Route::get('/list_sale', [saleController::class, 'listSale'])->name('list_sale');
Route::get('/list_sale_by_date/{date}', [saleController::class, 'listSaleByDate'])->name('list_sale_by_date');


Route::post('/list_sale', [saleController::class, 'listSale'])->name('list_sale');
Route::post('/store-endcashSubmit', [pettyCashController::class, 'storeEndcashSubmit'])->name('store-endcashSubmit');
Route::post('/store-startcashRegister', [pettyCashController::class, 'storeStartcashRegister'])->name('store-startcashRegister');

Route::get('/purchase_data', [PurchaseController::class, 'PurchaseData'])->name('purchase_data');
Route::get('/sale_data', [saleController::class, 'saleData'])->name('sale_data');
Route::get('/edit_sale_data', [saleController::class, 'editSaleData'])->name('edit_sale_data');
Route::get('/return_sale_data', [saleController::class, 'returnSaleData'])->name('return_sale_data');

Route::post('/transfer_product', [productController::class, 'transferProduct'])->name('transfer_product');


Route::get('/list_top-up_pettycash', [pettyCashController::class, 'topupPettycashList'])->name('list_top-up_pettycash');
Route::post('/delete-pettycash', [pettyCashController::class, 'deletePettycash'])->name('delete-pettycash');



Route::post('/delete-expenses-category', [pettyCashController::class, 'deleteExpensesCategory'])->name('delete-expenses-category');
Route::post('/delete-product-category', [productCategoryController::class, 'deleteProductCategory'])->name('delete-product-category');

Route::post('/delete-sub-product-category', [productCategoryController::class, 'deleteSubProductCategory'])->name('delete-sub-product-category');
Route::post('/delete-product-brand', [productbrandController::class, 'deleteProductBrand'])->name('delete-product-brand');

Route::post('/delete-expenses-subcategory', [pettyCashController::class, 'deleteExpensesSubCategory'])->name('delete-expenses-subcategory');


Route::get('/list_expenses_category', [pettyCashController::class, 'listExpensesCategory'])->name('list_expenses_category');
Route::get('/list_expenses_sub_category', [pettyCashController::class, 'listExpensesSubCategory'])->name('list_expenses_sub_category');

Route::get('/list_expenses', [expensesController::class, 'listExpenses'])->name('list_expenses');
Route::get('/delete_requested_list_expenses', [expensesController::class, 'DeleteRequestedlistExpenses'])->name('delete_requested_list_expenses');

Route::post('/delete-expenses', [pettyCashController::class, 'deleteExpenses'])->name('delete-expenses');
Route::post('/Request-delete-expenses', [expensesController::class, 'RequestdeleteExpenses'])->name('Request-delete-expenses');
Route::post('/accept-Request-delete-expenses', [expensesController::class, 'AcceptRequestdeleteExpenses'])->name('accept-Request-delete-expenses');





Route::get('/expenses_data', [expensesController::class, 'listExpensesData'])->name('expenses_data');
Route::get('/edit_expenses_data', [expensesController::class, 'updateExpensesData'])->name('edit_expenses_data');
Route::post('/update-expenses', [expensesController::class, 'updateExpenses'])->name('update-expenses');
Route::post('/delete-images', [expensesController::class, 'deleteImages'])->name('delete-images');


Route::get('/get_daily_report_list', [reportController::class, 'getDailyReportList'])->name('get_daily_report_list');

Route::get('/get_daily_report_list_by_date/{date}', [reportController::class, 'getDailyReportListByDate'])->name('get_daily_report_list_by_date');


Route::get('/get_monthly_report_list', [reportController::class, 'getAnalytic'])->name('get_monthly_report_list');
Route::get('/get_annualy_report_list', [reportController::class, 'getAnnualyReportList'])->name('get_annualy_report_list');
Route::get('/get_branch_report_list', [reportController::class, 'getBranchReportList'])->name('get_branch_report_list');



Route::post('/get-monthly-report-data', [reportController::class, 'getMonthlyReportData'])->name('get-monthly-report-data');
Route::post('/get-monthly-topUp-data', [reportController::class, 'getMonthlyTopupData'])->name('get-monthly-topUp-data');

Route::post('/get-branch-report-data', [reportController::class, 'getBranchEachData'])->name('get-branch-report-data');


Route::post('/get-annualy-report-data', [reportController::class, 'getAnnualyReportData'])->name('get-annualy-report-data');
Route::post('/get-annualy-topUp-data', [reportController::class, 'getAnnualyTopupData'])->name('get-annualy-topUp-data');
Route::post('/get-daily-topUp-data', [reportController::class, 'getDailyTopupData'])->name('get-daily-topUp-data');

Route::post('/get-daily-report-data', [reportController::class, 'getDailyReportData'])->name('get-daily-report-data');
Route::get('/user_list', [App\Http\Controllers\HomeController::class, 'userList'])->name('user_list');
Route::get('/branch_list', [App\Http\Controllers\HomeController::class, 'branchList'])->name('branch_list');
Route::post('/store-todo', [App\Http\Controllers\HomeController::class, 'storeTodo'])->name('store-todo');
Route::post('/delete-todo', [App\Http\Controllers\HomeController::class, 'deleteTodo'])->name('delete-todo');


Route::post('/store.productCategory', [productCategoryController::class, 'storeProductCategory'])->name('store.productCategory');
Route::post('/store.product.brand', [productbrandController::class, 'storeProductBrand'])->name('store.product.brand');
Route::post('/store.subCategory', [productCategoryController::class, 'storeSubCategory'])->name('store.subCategory');
Route::post('/store.supplier', [supplierController::class, 'storeSupplier'])->name('store.supplier');
Route::post('/store.costomer', [customerController::class, 'storeCostomer'])->name('store.costomer');
Route::post('/delete.costomer', [customerController::class, 'deleteCostomer'])->name('delete.costomer');

Route::post('/update.costomer', [customerController::class, 'updateCostomer'])->name('update.costomer');
Route::post('/store-sale', [saleController::class, 'storeSale'])->name('store-sale');
Route::post('/store-payment', [saleController::class, 'storePayment'])->name('store-payment');
Route::post('/store-purchase-payment', [PurchaseController::class, 'storePurchasePayment'])->name('store-purchase-payment');




Route::post('/update-sale', [saleController::class, 'updateSale'])->name('update-sale');

Route::post('/delete-sale-product', [saleController::class, 'deleteSaleProduct'])->name('delete-sale-product');

Route::post('/return_sale_product', [saleController::class, 'returnSaleProduct'])->name('return_sale_product');

Route::post('/return_product', [saleController::class, 'returnProductData'])->name('return_product');

Route::GET('/sale_product_return', [saleController::class, 'returnProduct'])->name('sale_product_return');

Route::GET('/sale_product_return_by_barcode', [saleController::class, 'returnProductBarcode'])->name('sale_product_return_by_barcode');

Route::post('/store-purchase', [PurchaseController::class, 'storePpurchase'])->name('store-purchase');

Route::post('/update-purchase', [PurchaseController::class, 'updatePurchase'])->name('update-purchase');

Route::post('/prduct_list_data', [productController::class, 'prductlistData'])->name('prduct_list_data');


Route::post('/update-purchase-item', [PurchaseController::class, 'updatePurchaseItem'])->name('update-purchase-item');


Route::post('/store-purchase-by-items', [PurchaseController::class, 'storePpurchaseByItems'])->name('store-purchase-by-items');

Route::post('/delete-purchase-product', [PurchaseController::class, 'deletePurchaseProduct'])->name('delete-purchase-product');

Route::post('/return-purchase', [PurchaseController::class, 'returnPurchase'])->name('return-purchase');

Route::post('/get.product.brand', [POSController::class, 'getProductBrand'])->name('get.product.brand');

Route::post('/get.product.model', [POSController::class, 'getProductModel'])->name('get.product.model');

Route::post('/get.product.model.item', [POSController::class, 'getProductModelItem'])->name('get.product.model.item');
