
<?php $__env->startSection('content'); ?>

<style>
  button.dt-button, div.dt-button, a.dt-button, input.dt-button {
    border-radius: 5px;
    color: white;
    background-color: rgb(197, 7, 178);
    box-shadow: rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset;
}

button.dt-button:hover:not(.disabled), div.dt-button:hover:not(.disabled), a.dt-button:hover:not(.disabled), input.dt-button:hover:not(.disabled) {
    border: 1px solid #666;
    background-color: rgb(29, 29, 29);
}

.content form {
        border: 12px solid #f8f8f8;
        background: #f4f4f4;
        padding: 30px 45px 45px;
        margin: 70px 25px 40px;
        border-radius: 5px;
        max-width: 900px;
        box-shadow: 0 1px 7px rgba(0,0,0,0.2);
    }
    .content label {
        display: block;
        font-weight: bold;
        letter-spacing: 0.02em; 
        color: #666;
        text-shadow: 0 0 0 #666;
        padding: 5px 0 8px;
    }
    .content label:not(:first-of-type) {
        margin-top: 30px;
    }
    .content select {   
        width: 100%;
        max-width: 300px;
    }

    /* LC Select - Light theme - by LCweb */


/* container */
.lcslt {
    border: 1px solid #aaa;
    background: #fafafa;
    border-radius: 2px;
    transition: all .25s ease;
    font-size: 15px;
}
.lcslt:not(.lcslt-disabled):hover,
.lcslt.lcslt_dd-open,
#lc-select-dd {
    border-color: #8f8f8f;
    background: #fefefe;
}
.lcslt.lcslt_dd-open {
    border-bottom-left-radius: 0;
    border-bottom-right-radius: 0;
}
.lcslt-opt {
    background: #bbb;
    border-radius: 3px;
}
.lcslt:not(.lcslt-multiple):after {
	border-top-color: #888 !important;
}
.lcslt:not(.lcslt-multiple):hover:after,
.lcslt.lcslt_dd-open:not(.lcslt-multiple):after {
	border-top-color: #666 !important;
}
.lcslt:not(.lcslt-multiple) > span {
    padding: 2px 0;
}
.lcslt.lcslt-multiple > span:not(.lcslt-multi-callout) {
    padding: 3px 0 6px;
}
.lcslt:not(.lcslt-multiple) > span:not(.lcslt-placeholder) {
    font-size: 100%;
}
.lcslt > span:not(.lcslt-placeholder):not(.lcslt-multi-callout),
#lc-select-dd li {
    color: #484848;
}


/* disabled status */
.lcslt.lcslt-disabled {
    background: #f4f4f4;
}
.lcslt.lcslt-disabled:not(.lcslt-multiple):after {
	border-top-color: #aaa !important;
}
.lcslt.lcslt-disabled:not(.lcslt-multiple) > span {
    color: #848484;
}
.lcslt.lcslt-disabled .lcslt-multi-selected {
    color: #666;
    padding-left: 9px;
}
.lcslt.lcslt-disabled .lcslt-multi-selected:before {
    display: none;
}


/* multi-option selected items */
.lcslt-multiple {
	font-size: 0.95rem !important;
}
.lcslt-multi-selected,
.lcslt-multi-callout {
    padding: 3px 9px 3px 7px;
    background: #e5e5e5;
    color: #494949;
    border-radius: 50px;
    margin: 0 5px 5px 0;
    transition: all .3s ease;
}
.lcslt-multi-callout {
	padding: 0.75rem 0.4581rem;
	font-family: arial;
	border-radius: 50%;
	font-size: 1rem;
}
.lcslt:not(.lcslt-disabled) .lcslt-multi-selected:hover,
.lcslt:not(.lcslt-disabled) .lcslt-multi-callout:hover {
    background: #ddd;
    color: #3f3f3f; 
}
.lcslt-multi-selected:before {
    padding-right: 6px;
}
.lcslt-placeholder {
	color: #888;
	transform: scale(0.9) translate3d(-5%, -5%, 0);
}


/* dropdown */
#lc-select-dd {
    border-radius: 0 0 4px 4px;
    border-width: 0 1px 1px;
    border-style: solid;
	box-shadow: 0px 3px 3px rgba(0, 0, 0, 0.2);
	font-size: 13px;
    
}
#lc-select-dd li {
    border: none;
    border-top: 1px solid #ddd;
}
.lcslt-search-li {
    border-bottom: 2px dotted #bababa !important;
    box-shadow: 0 1px 0 #fff;
}
.lcslt-search-li input {
	font-size: inherit;
    padding-top: 8px;
    padding-bottom: 8px;
    padding-left: 8px;
    /* font-size: 0.8rem; */
    color: #888;
    background: #fefefe;
}
.lcslt-search-li input:hover,
.lcslt-search-li input:active,
.lcslt-search-li input:focus,
.lcslt-is-searching .lcslt-search-li input {
    color: inherit;
}
.lcslt-search-li:before {
	background: #666;
}
#lc-select-dd li span {
    padding: 7px 12px;
    /* font-size: 0.8rem; */
}
#lc-select-dd li img { 
    padding-right: 7px;
}
.lcslt-group-name {
    font-weight: bold;
}
.lcslt-group-opts > li {
    padding-left: 12px;
}
.lcslt-dd-opt {   
    transition: all .15s ease;
    color: #6f6f6f;
}
#lc-select-dd li.lcslt-dd-opt:not(.lcslt-disabled):not(.lcslt-selected):hover,
#lc-select-dd .lcslt-dd-opt-hlight {  
    color: #333;
    background: #d7eeff;
}
#lc-select-dd li.lcslt-dd-opt.lcslt-disabled {   
    background: #ededed;
    color: #777;
}
#lc-select-dd li.lcslt-selected {   
    color: #fff;
    background: #0078d7;
    text-shadow: 0 0 2px rgba(0,0,0,0.15);
}
#lc-select-dd li.lcslt-selected.lcslt-dd-opt-hlight {
	box-shadow: 6px 0 0 #89caff inset;
}
.lcslt-is-searching li.lcslt-group,
.lcslt-no-results {
    border: none !important;
}
.lcslt-no-results {
    color: #777;
    text-align: center;
    padding: 12px;
}


/* images */
.lcslt-img {
    display: inline-block;
    height: 50px;
    width: 70px;
    margin-right: 20px;
} */
.content-wrapper {
    display: flex;
    justify-content: center; /* Centers horizontally */
    align-items: center;    /* Centers vertically */
           /* Full viewport height */
              /* Full width */
}

.inner-wrapper {
    display: flex;
    justify-content: center;
    align-items: center;
    width: 100%;
}

:root{
    --file-container-bg:  #eeeeee;
    --file-bg:  #f8f8f8;
    --file-border-color: #606060;
    --file-rounded: 15px;
    --file-color: #2b2b2b;
    --table-border-color: #dbdbdb;
    --delete-button-bg: #f53636;
    --delete-button-color: #ffffff;
    --font-size: 0.875em;
    --font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    --shadow: 0px 8px 15px -8px rgba(0, 0, 0, 0.5);
}

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

.file-container {
    width: 100%;
    font-family: var(--font-family);

    .file-upload {
        width: 100%;
        display: flex;
        background-color: var(--file-container-bg);
        border-radius: var(--file-rounded);
        transition: all 0.3s;

        &:hover {
            box-shadow: var(--shadow);
        }

        >div {
            width: 100%;
            background-color: var(--file-bg);
            padding: 25px;
            margin: 25px;
            border-radius: 10px;
            border: 1px dashed var(--file-border-color);
            text-align: center;
            cursor: pointer;

            >i {
                font-size: 3.125em;
                color: var(--file-color);
            }

            >p,
            span,
            div {
                font-size: var(--font-size);
                line-height: 30px;
                color: var(--file-color);
            }

            >div {
                width: max-content;
                padding: 0 10px;
                margin: 0 auto;
                border: 1px solid var(--file-border-color);
                border-radius: 8px;
            }
        }
    }

    >table {
        width: 100%;
        border-collapse: collapse;
        font-size: var(--font-size);
        margin-top: 20px;

        & th,
        td {
            border-bottom: 1px solid var(--table-border-color);
            padding: 8px;
            text-align: left;
        }

        >tbody {
            >tr {
                >td {
                    &:nth-child(1) {
                        font-weight: bold;
                    }

                    &:nth-child(2) {
                        white-space: nowrap;
                        text-overflow: ellipsis;
                        overflow: hidden;
                        max-width: 1px;
                    }

                    &:nth-child(3) {
                        text-align: center;
                    }

                    >img {
                        border-radius: 5px;
                        box-shadow: var(--shadow);
                    }

                    &.no-file {
                        text-align: center;
                        font-weight: normal;
                    }

                    > i{
                        font-size: 1.125em;
                    }
                }
            }
        }

        & button {
            background-color: var(--delete-button-bg);
            width: 30px;
            height: 30px;
            border: none;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            cursor: pointer;

            &:hover {
                box-shadow: var(--shadow);
            }

            >i {
                color: var(--delete-button-color);
                font-size: 1.125em;
            }
        }
    }
}
.form-group label .text-danger {
        font-weight: bold; /* Emphasize the asterisk */
    }

    /* Optional: Highlight input field for compulsory fields */
    .form-control.is-compulsory:required {
        border-color: red;
        
    }

    .form-control.is-compulsory:focus {
        outline: none;
        box-shadow: 0 0 5px red;
        border-color: red;
    }

</style>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="content-wrapper ">
            <div class="inner-wrapper">
             <div class="col-10 grid-margin stretch-card">
                <div class="card">
                  <div class="card-body">
                    <h4 class="card-title">Add Products & Services</h4>
                    
                    <form class="forms-sample">

                    <div class="form-group">
                         <label for="exampleInputName1 " style="font-size: 0.85rem;">Select Type<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                            <select class="select form-control" id="Type">
								<option value="Products">Products</option>
                                <option value="Product Items">Products Items</option>
								<option value="Services">Services</option>
								

							</select>
                        </div>
                      <div class="form-group">
                        <label for="exampleInputName1 " style="font-size: 0.85rem;">Product Name<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                        <input type="text" class="form-control" id="ProductName" placeholder="Add Product Name Here">
                      </div>
                      
                      <div class="form-group">
                        <label for="exampleInputEmail3 " style="font-size: 0.85rem;">Product Code<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="Code" placeholder="Product Cod Here">
                            <div class="input-group-append">
                                <span class="input-group-text" id="generateRandom">
                                    <i class="fa fa-random" style="cursor: pointer;"></i>
                                </span>
                            </div>
                        </div>
                        
                      </div>
                      

                        <div class="form-group" id="portionSizesSection" >
                         <label for="exampleInputName1 " style="font-size: 0.85rem;">Select portion sizes<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                            <select class="select form-control" id="portionSizes">
                                	<option value="">Select</option>
								<option value="Small">Small</option>
								<option value="Full">Full</option>
								<option value="Large">Large</option>
                                <option value="Extra Large">Extra Large</option>
							</select>
                        </div>


                      <div class="form-group">
                        <label for="exampleSelectGender" style="font-size: 0.85rem;">Select Product Catecory<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                        <select name="simple" data-placeholder="Select something please .." id="Category">
                            <?php $__currentLoopData = $productCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            
                                
                                <option value="<?php echo e($productCategory->id); ?>">
                                <?php echo e($productCategory->category_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </select>
                        </div>

                        
                      <div class="form-group">
                        <label style="font-size: 0.85rem;">Select Product Sub Catecory</label>
                        <select id="subCategory" name="simple" data-placeholder="Select something please ..">
                    
                        </select>
                      </div>
                      <div class="form-group" id="brandArea">
                        <label for="exampleSelectGender" style="font-size: 0.85rem;" >Select Product Brand</label>
                        <select name="simple" data-placeholder="Select something please .." id="brand">
                            
                      </select>
                        </div>
                        <div class="form-group" id="productModelSection">
                        <label for="exampleInputPassword4 " style="font-size: 0.85rem;">Product Model</label>
                        <input type="text" class="form-control" id="productModel" placeholder="Product Model Here">
                      </div>
                      <div class="form-group">
                        <label for="exampleInputCity1 " style="font-size: 0.85rem;">Product Price<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                        <input type="text" class="form-control" id="Price" placeholder="Product Price">
                      </div>
                  
                    
                      <div class="form-group">
                        <label for="exampleTextarea1" style="font-size: 0.85rem;">Description</label>
                        <textarea class="form-control" id="description" rows="4"></textarea>
                      </div>  
                      <div class="container form-group">
                        <div class="row">
                            <div class="col-sm">
                                <label for="exampleInputCity1 " style="font-size: 0.85rem;">Wholesale Price<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                                <input type="text" class="form-control" id="WholesalePrice" placeholder="Wholesale Price">
                            </div>
                            <div class="col-sm">
                                <label for="exampleInputCity1 " style="font-size: 0.85rem;">Wholesale Quantity<span class="text-danger" style="font-size: 1.5rem;">*</span></label>
                                <input type="text" class="form-control" id="WholesaleQuantity" placeholder="Wholesale Quantity">
                            </div>
  
                        </div>
                    </div>

                      <div class="form-group">
                        <label for="exampleInputName1 " style="font-size: 0.85rem;">Alert Quantity</label>
                        <input type="text" class="form-control" id="AlertQuantity" placeholder="Add Alert Quantity Here">
                      </div>
                      <div class="form-group">
                        <label for="exampleTextarea1" style="font-size: 0.85rem;">Upload Images</label>
                        <div class=" grid-margin stretch-card">
                            <div class="card">
                              <div class="">
                                
                                <input type="file" class="dropify" id="image" />
                              </div>
                            </div>
                          </div>
                      </div>

                    
                      <button type="submit" class="btn btn-primary mr-2" id="submit">Submit</button>
                      <button class="btn btn-light">Cancel</button>
                    </form>
                  </div>
                </div>
              </div>
          
            </div>
         </div>
            <div class="row">
            <div class="col-12">
              <div class="card">
                <div class="card-body">
                  <div class="d-md-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-facebook btn-rounded">
                        <i class="fab fa-facebook-f"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Facebook</h5>
                        <p class="mb-0">813 friends</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-twitter btn-rounded">
                        <i class="fab fa-twitter"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Twitter</h5>
                        <p class="mb-0">9000 followers</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center mb-3 mb-md-0">
                      <button class="btn btn-social-icon btn-google btn-rounded">
                        <i class="fab fa-google-plus-g"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Google plus</h5>
                        <p class="mb-0">780 friends</p>
                      </div>
                    </div>
                    <div class="d-flex align-items-center">
                      <button class="btn btn-social-icon btn-linkedin btn-rounded">
                        <i class="fab fa-linkedin-in"></i>
                      </button>
                      <div class="ml-4">
                        <h5 class="mb-0">Linkedin</h5>
                        <p class="mb-0">1090 connections</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- content-wrapper ends -->
        <!-- partial:../../partials/_footer.html -->
        <footer class="footer">
          <div class="d-sm-flex justify-content-center justify-content-sm-between">
            <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">Copyright © 2025  <a href="https://www.urbanui.com/" target="_blank">Urbanui</a>. All rights reserved.</span>
            <span class="float-none float-sm-right d-block mt-1 mt-sm-0 text-center">Hand-crafted & made with <i class="far fa-heart text-danger"></i></span>
          </div>
        </footer>
        <!-- partial -->
      </div>
      
     
      <script>
$( document ).ready(function() {



    new lc_select(document.querySelector('#Category'), {
        wrap_width: '100%',
        min_for_search: 2,
        pre_placeh_opt: true,
    });
    new lc_select(document.querySelector('#subCategory'), {
        wrap_width: '100%',
        min_for_search: 2,
        pre_placeh_opt: true,
    });
    new lc_select(document.querySelector('#brand'), {
        wrap_width: '100%',
        min_for_search: 2,
        pre_placeh_opt: true,
    });
    

    $(document).on("click", "#generateRandom", function () {
        // Generate a random 8-character number
        const randomCode = Math.floor(10000000 + Math.random() * 90000000);
        // Set the random number in the input field
        $("#Code").val(randomCode);
    });

    var productstype = "Products";
      $("#portionSizesSection").hide(); 
    $(document).on('change', '#Type', function () {
        var productstype = $(this).val().trim(); // trim to remove unwanted whitespace// debug

        if (productstype !== "Products") {
            
            if (productstype == "Foods & Beverages") {
                $("#portionSizesSection").show(); 
                $("#brandArea").hide();
                 $("#productModelSection").hide();  
            }
             if (productstype == "Services") {
                $("#portionSizesSection").hide(); 
                $("#brandArea").hide();
                 $("#productModelSection").hide();  
            }
            else{
                
                $("#portionSizesSection").hide(); 
                 $("#brandArea").show();
                  $("#productModelSection").show();  
            }
 
            // hide if not 'Products'
        } 
        
        else {
            $("#brandArea").show(); // show if 'Products'
             $("#productModelSection").show(); 
                  $("#portionSizesSection").hide(); 
        }
    });

    $(document).on('change','#Category', function(){
      
            var id = $('#Category').val();
 
            $.ajax({
                url: "<?php echo e(route('get-product-sub-categories')); ?>",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'POST',
                data: {'id':id},
            
                success: function(response) {
        // Access the productSubCategory data
        $('#subCategory').empty();  // Clear existing options
        $('#subCategory').append('<option value="">Select Sub Category</option>');
        $.each(response.data.productSubCategory, function(index, subCategory) {
            $('#subCategory').append('<option value="' + subCategory.id + '">' + subCategory.sub_category_name + '</option>');
        });

        // Access the productBrandCategory data
        $('#brand').empty();  // Clear existing options
        $('#brand').append('<option value="">Select Brand Category</option>');
        $.each(response.data.productBrandCategory, function(index, brand) {
            $('#brand').append('<option value="' + brand.id + '">' + brand.product_brand_name + '</option>');
        });
    },
                error: function(xhr, textStatus, errorThrown) {
                    alert('Form submission failed!');
                }
            });
        })
  // alert("hi")

  // $(document).on('click','#submit', function(e){
  //   e.preventDefault();
  //   var expensesImages = $('input[name="expensesImages[]"]').prop('files');
  //   if (expensesImages.length > 0) {
  //       // Iterate over the FileList and alert each file name
  //       for (var i = 0; i < expensesImages.length; i++) {
  //           alert(expensesImages[i].name);
  //       }
  //   } else {
  //       alert("No files selected.");
  //   }
  // })
  $(document).on("keydown", function (e) {
    if (e.key === "Enter" || e.keyCode === 13) {
        e.preventDefault(); // Prevent the default action for the Enter key
    }
});

       
  $(document).on("click", "#submit", function (e) {
        e.preventDefault();
        var ProductName =$('#ProductName').val();
        var description =$('#description').val();
        var brand =$('#brand').val();
        var Code =$('#Code').val();
        var AlertQuantity =$('#AlertQuantity').val();
        var productModel =$('#productModel').val();
        var portionSizes =$('#portionSizes').val();
        var producttypes =$('#Type').val();
        var WholesalePrice =$('#WholesalePrice').val();
        var WholesaleQuantity =$('#WholesaleQuantity').val();
        var subCategory =$('#subCategory').val();
        var Category =$('#Category').val();
        var Price =$('#Price').val();
        var image = $('#image')[0].files[0];

        var isValid = true;
            var errorMessage = '';

            // Perform individual validation checks for each input field
        if (!ProductName || ProductName.length === 0) {
            errorMessage += 'Product Name is required.<br>';
            isValid = false;
        }
        if (!Category || Category.length === 0) {
            errorMessage += 'Category is required.<br>';
            isValid = false;
        }
        if (!Code || Code.length === 0) {
            errorMessage += 'Code is required.<br>';
            isValid = false;
        }
        if (!Price || Price.length === 0) {
            errorMessage += 'Price is required.<br>';
            isValid = false;
        }
      
        if (!isValid) {
                Swal.fire({
                    icon: 'error',
                    title: 'Validation Error',
                    html: errorMessage,
                    showCloseButton: true,
                    showCancelButton: false,
                    focusConfirm: false,
                    confirmButtonText: 'OK',
                });
                return;
      }else{
        var form_data = new FormData();
            form_data.append('_token', '<?php echo e(csrf_token()); ?>');
            form_data.append('ProductName', ProductName);
            form_data.append('model', productModel);
             form_data.append('portionSizes', portionSizes); 
            form_data.append('brand', brand);
            form_data.append('Code', Code);
            form_data.append('WholesaleQuantity', WholesaleQuantity);
            form_data.append('WholesalePrice', WholesalePrice); 
            form_data.append('Price', Price);
            form_data.append('Category', Category);
            form_data.append('AlertQuantity', AlertQuantity);
            form_data.append('subCategory', subCategory);
            form_data.append('productstype', producttypes);
            
            form_data.append('description', description);
            if (image) {
                form_data.append('image', image); // Add image to FormData
            }

            $.ajax({
                url: '/store-product', // Replace with your backend URL
                type: 'POST',
                data: form_data,
                contentType: false,
                processData: false,
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: 'Your data has been submitted successfully!',
                        confirmButtonText: 'OK',
                    }).then((result) => {
                      if (result.isConfirmed) {
                         window.location.reload();
                      }
                    });
                },
                error: function (response) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'There was an error submitting your data.',
                        confirmButtonText: 'OK',
                    });
                }
            });
      }
              
    });
  


  $('#example').DataTable({
            dom: "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            processing: true,
            info: true,
            responsive: true,
            lengthMenu: [
                [10, 25, 50, 100, 200, -1],
                [10, 25, 50, 100, 200, "All"]
            ],


           
            createdRow: function(row, data, dataIndex) {
            // Example condition to change font color
            // Adjust condition as needed
                $(row).css('font-size', '15px');
           
        }
        });
});
      
      </script>
<?php $__env->stopSection(); ?>
      <!-- main-panel ends -->
    
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\USER\Desktop\pos\susmart\resources\views/Section/Product/addProduct.blade.php ENDPATH**/ ?>