
<?php $__env->startSection('content'); ?>
<style>
  button.dt-button, div.dt-button, a.dt-button, input.dt-button {
    border-radius: 5px;
    color: white;
    background-color: rgb(197, 7, 178);
    box-shadow: rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset;
}

button.dt-button:hover:not(.disabled), div.dt-button:hover:not(.disabled), a.dt-button:hover:not(.disabled), input.dt-button:hover:not(.disabled) {
    border: 1px solid #666;
    background-color: rgb(29, 29, 29);
}

.content form {
        border: 12px solid #f8f8f8;
        background: #f4f4f4;
        padding: 30px 45px 45px;
        margin: 70px 25px 40px;
        border-radius: 5px;
        max-width: 900px;
        box-shadow: 0 1px 7px rgba(0,0,0,0.2);
    }
    .content label {
        display: block;
        font-weight: bold;
        letter-spacing: 0.02em; 
        color: #666;
        text-shadow: 0 0 0 #666;
        padding: 5px 0 8px;
    }
    .content label:not(:first-of-type) {
        margin-top: 30px;
    }
    .content select {   
        width: 100%;
        max-width: 300px;
    }

    /* LC Select - Light theme - by LCweb */


/* container */
.lcslt {
    border: 1px solid #aaa;
    background: #fafafa;
    border-radius: 2px;
    transition: all .25s ease;
    font-size: 15px;
}
.lcslt:not(.lcslt-disabled):hover,
.lcslt.lcslt_dd-open,
#lc-select-dd {
    border-color: #8f8f8f;
    background: #fefefe;
}
.lcslt.lcslt_dd-open {
    border-bottom-left-radius: 0;
    border-bottom-right-radius: 0;
}
.lcslt-opt {
    background: #bbb;
    border-radius: 3px;
}
.lcslt:not(.lcslt-multiple):after {
	border-top-color: #888 !important;
}
.lcslt:not(.lcslt-multiple):hover:after,
.lcslt.lcslt_dd-open:not(.lcslt-multiple):after {
	border-top-color: #666 !important;
}
.lcslt:not(.lcslt-multiple) > span {
    padding: 2px 0;
}
.lcslt.lcslt-multiple > span:not(.lcslt-multi-callout) {
    padding: 3px 0 6px;
}
.lcslt:not(.lcslt-multiple) > span:not(.lcslt-placeholder) {
    font-size: 130%;
}
.lcslt > span:not(.lcslt-placeholder):not(.lcslt-multi-callout),
#lc-select-dd li {
    color: #484848;
}


/* disabled status */
.lcslt.lcslt-disabled {
    background: #f4f4f4;
}
.lcslt.lcslt-disabled:not(.lcslt-multiple):after {
	border-top-color: #aaa !important;
}
.lcslt.lcslt-disabled:not(.lcslt-multiple) > span {
    color: #848484;
}
.lcslt.lcslt-disabled .lcslt-multi-selected {
    color: #666;
    padding-left: 9px;
}
.lcslt.lcslt-disabled .lcslt-multi-selected:before {
    display: none;
}


/* multi-option selected items */
.lcslt-multiple {
	font-size: 0.95rem !important;
}
.lcslt-multi-selected,
.lcslt-multi-callout {
    padding: 3px 9px 3px 7px;
    background: #e5e5e5;
    color: #494949;
    border-radius: 50px;
    margin: 0 5px 5px 0;
    transition: all .3s ease;
}
.lcslt-multi-callout {
	padding: 0.75rem 0.4581rem;
	font-family: arial;
	border-radius: 50%;
	font-size: 1rem;
}
.lcslt:not(.lcslt-disabled) .lcslt-multi-selected:hover,
.lcslt:not(.lcslt-disabled) .lcslt-multi-callout:hover {
    background: #ddd;
    color: #3f3f3f; 
}
.lcslt-multi-selected:before {
    padding-right: 6px;
}
.lcslt-placeholder {
	color: #888;
	transform: scale(0.9) translate3d(-5%, -5%, 0);
}


/* dropdown */
#lc-select-dd {
    border-radius: 0 0 4px 4px;
    border-width: 0 1px 1px;
    border-style: solid;
	box-shadow: 0px 3px 3px rgba(0, 0, 0, 0.2);
	font-size: 13px;
    
}
#lc-select-dd li {
    border: none;
    border-top: 1px solid #ddd;
}
.lcslt-search-li {
    border-bottom: 2px dotted #bababa !important;
    box-shadow: 0 1px 0 #fff;
}
.lcslt-search-li input {
	font-size: inherit;
    padding-top: 8px;
    padding-bottom: 8px;
    padding-left: 8px;
    /* font-size: 0.8rem; */
    color: #888;
    background: #fefefe;
}
.lcslt-search-li input:hover,
.lcslt-search-li input:active,
.lcslt-search-li input:focus,
.lcslt-is-searching .lcslt-search-li input {
    color: inherit;
}
.lcslt-search-li:before {
	background: #666;
}
#lc-select-dd li span {
    padding: 7px 12px;
    /* font-size: 0.8rem; */
}
#lc-select-dd li img { 
    padding-right: 7px;
}
.lcslt-group-name {
    font-weight: bold;
}
.lcslt-group-opts > li {
    padding-left: 12px;
}
.lcslt-dd-opt {   
    transition: all .15s ease;
    color: #6f6f6f;
}
#lc-select-dd li.lcslt-dd-opt:not(.lcslt-disabled):not(.lcslt-selected):hover,
#lc-select-dd .lcslt-dd-opt-hlight {  
    color: #333;
    background: #d7eeff;
}
#lc-select-dd li.lcslt-dd-opt.lcslt-disabled {   
    background: #ededed;
    color: #777;
}
#lc-select-dd li.lcslt-selected {   
    color: #fff;
    background: #0078d7;
    text-shadow: 0 0 2px rgba(0,0,0,0.15);
}
#lc-select-dd li.lcslt-selected.lcslt-dd-opt-hlight {
	box-shadow: 6px 0 0 #89caff inset;
}
.lcslt-is-searching li.lcslt-group,
.lcslt-no-results {
    border: none !important;
}
.lcslt-no-results {
    color: #777;
    text-align: center;
    padding: 12px;
}


/* images */
.lcslt-img {
    display: inline-block;
    height: 50px;
    width: 70px;
    margin-right: 20px;
} */
.content-wrapper {
    display: flex;
    justify-content: center; /* Centers horizontally */
    align-items: center;    /* Centers vertically */
           /* Full viewport height */
              /* Full width */
}

.inner-wrapper {
    display: flex;
    justify-content: center;
    align-items: center;
    width: 100%;
}

:root{
    --file-container-bg:  #eeeeee;
    --file-bg:  #f8f8f8;
    --file-border-color: #606060;
    --file-rounded: 15px;
    --file-color: #2b2b2b;
    --table-border-color: #dbdbdb;
    --delete-button-bg: #f53636;
    --delete-button-color: #ffffff;
    --font-size: 0.875em;
    --font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    --shadow: 0px 8px 15px -8px rgba(0, 0, 0, 0.5);
}

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

.file-container {
    width: 100%;
    font-family: var(--font-family);

    .file-upload {
        width: 100%;
        display: flex;
        background-color: var(--file-container-bg);
        border-radius: var(--file-rounded);
        transition: all 0.3s;

        &:hover {
            box-shadow: var(--shadow);
        }

        >div {
            width: 100%;
            background-color: var(--file-bg);
            padding: 25px;
            margin: 25px;
            border-radius: 10px;
            border: 1px dashed var(--file-border-color);
            text-align: center;
            cursor: pointer;

            >i {
                font-size: 3.125em;
                color: var(--file-color);
            }

            >p,
            span,
            div {
                font-size: var(--font-size);
                line-height: 30px;
                color: var(--file-color);
            }

            >div {
                width: max-content;
                padding: 0 10px;
                margin: 0 auto;
                border: 1px solid var(--file-border-color);
                border-radius: 8px;
            }
        }
    }

    >table {
        width: 100%;
        border-collapse: collapse;
        font-size: var(--font-size);
        margin-top: 20px;

        & th,
        td {
            border-bottom: 1px solid var(--table-border-color);
            padding: 8px;
            text-align: left;
        }

        >tbody {
            >tr {
                >td {
                    &:nth-child(1) {
                        font-weight: bold;
                    }

                    &:nth-child(2) {
                        white-space: nowrap;
                        text-overflow: ellipsis;
                        overflow: hidden;
                        max-width: 1px;
                    }

                    &:nth-child(3) {
                        text-align: center;
                    }

                    >img {
                        border-radius: 5px;
                        box-shadow: var(--shadow);
                    }

                    &.no-file {
                        text-align: center;
                        font-weight: normal;
                    }

                    > i{
                        font-size: 1.125em;
                    }
                }
            }
        }

        & button {
            background-color: var(--delete-button-bg);
            width: 30px;
            height: 30px;
            border: none;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            cursor: pointer;

            &:hover {
                box-shadow: var(--shadow);
            }

            >i {
                color: var(--delete-button-color);
                font-size: 1.125em;
            }
        }
    }
}
.modal-lg {
            max-width: 60%;
        }
        .modal-backdrop {
            background-color: rgba(47, 47, 47, 0.355);
        }

</style>
      <!-- partial -->
      
                              
                          
                              
    
        
      <div class="main-panel">
        <div class="content-wrapper">
       
          <div class="row">
            <div class="col-12">
              <div class="card">
                <div class="card-body">
                  <div class="row">
                    <div class="col-lg-5">
                    
                      <div class="py-4">
                        <h5 class="float-left">
                          <?php echo e($ExpensesData->expenses); ?>

                          </h5>
                        <p class="clearfix">
                          <h6 class="float-left">
                          Date
                          </h6>
                          <span class="float-right text-muted">
                            <?php echo e($ExpensesData->date); ?>

                          </span>
                        </p>
                        <p class="clearfix">
                          <h6 class="float-left">
                            Category
                          </h6>
                          <span class="float-right text-muted">
                            <?php echo e($ExpensesData->expenses_category); ?>

                          </span>
                        </p>
                        <p class="clearfix">
                          <h6 class="float-left">
                            Sub Category
                          </h6>
                          <span class="float-right text-muted">
                            <?php echo e($ExpensesData->expenses_sub_category); ?>

                          </span>
                        </p>
                        <p class="clearfix" >
                          <div >
                            <h6 class="float-left">
                              Amount
                            </h6>
                            <span class="float-right text-muted">
                              <?php echo e($ExpensesData->amount); ?>

                            </span>
                          </div>
                          
                        </p>
                        <p class="clearfix">
                          <h6 class="float-left">
                            Branch Name
                          </h6>
                          <span class="float-right text-muted">
                            <?php echo e($ExpensesData->branch_name); ?>

                          </span>
                        </p>
                        <br><br>
                        <div class="">
                    
                          <div class="ml-4">
                          
                            
                            <div class="container-lg my-3">
                              <div id="myCarousel" class="carousel slide" data-bs-ride="carousel">
                                  <!-- Carousel indicators -->
                                  <ol class="carousel-indicators">
                                    <?php $__currentLoopData = $ExpensesData->Expenses_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li data-bs-target="#myCarousel" data-bs-slide-to="<?php echo e($key); ?>" class="<?php echo e($key == 0 ? 'active' : ''); ?>"></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ol>
                                
                                <div class="carousel-inner">
                                    <?php $__currentLoopData = $ExpensesData->Expenses_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="carousel-item <?php echo e($key == 0 ? 'active' : ''); ?>" style="height: 400px;">
                                            <img src="<?php echo e(asset('assets/Expenses/' . $image->image_name)); ?>"  class="d-block w-100" alt="Slide <?php echo e($key + 1); ?>" data-bs-toggle="modal" data-bs-target="#imageModal" data-bs-image="<?php echo e(asset('assets/Expenses/' . $image->image_name)); ?>">
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                
                                <!-- Modal -->
                                <div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true" style="background-color: rgba(1, 1, 1, 0.519)">
                                    <div class="modal-dialog modal-lg modal-dialog-centered">
                                        <div class="modal-content" style="background-color: rgba(0, 0, 0, 0); heigh" >
                                         
                                            <div class="modal-body">
                                                <img id="modalImage" src="" class="img-fluid" alt="Image Preview">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                          
                                  <!-- Carousel controls -->
                                  <a class="carousel-control-prev" href="#myCarousel" data-bs-slide="prev">
                                      <span class="carousel-control-prev-icon"></span>
                                  </a>
                                  <a class="carousel-control-next" href="#myCarousel" data-bs-slide="next">
                                      <span class="carousel-control-next-icon"></span>
                                  </a>
                              </div>
                          </div>
                            </p>
                          </div>
                        </div>
                      </div>
                     
                    </div>
                    <div class="col-lg-7 pl-lg-5">
                      <div class="d-flex justify-content-between">
                        <div>
                          
                          <div class="d-flex align-items-center">
                           
                            
                          </div>
                        </div>
                        <div>
                          <button class="btn btn-outline-secondary btn-icon">
                            <i class="far fa-edit"></i>
                          </button>
                          <button class="btn btn-primary edit" data-id="<?php echo e($ExpensesData->id); ?>">Update</button>
                        </div>
                      </div>
                     
                      <div class="profile-feed">
                        <div class="d-flex align-items-start profile-feed-item">
                      
                          <div class="ml-4">
                            <h6>
                           Description
                            
                            </h6>
                            <p>
                              <?php echo e($ExpensesData->description); ?>

                            </p>
                            <p class="small text-muted mt-2 mb-0">
                              
                            </p>
                          </div>
                        </div>
                        <div class="">
                    
                          <div class="ml-4">
                          
                            <table id="sortable-table-1" class="table">
                              <thead>
                                <tr style="background-color:#E6E6FA;">
                                  <th>#</th>
                                  <th style="color: :red;" class="sortStyle">Item Name<i class="fa fa-angle-down"></i></th>
                                  <th class="sortStyle">Quantity<i class="fa fa-angle-down"></i></th>
                                  <th class="sortStyle">Price<i class="fa fa-angle-down"></i></th>
                                  <th class="sortStyle">Total Price<i class="fa fa-angle-down"></i></th>
                      
                                </tr>
                              </thead>
                              <tbody>
                                <?php $__currentLoopData = $ExpensesData->PurchaseItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <tr>
                                    <td><?php echo e($key + 1); ?></td>
                                    <td><?php echo e($item->item_name); ?></td>
                                    <td><?php echo e($item->item_quantity); ?></td>
                                    <td><?php echo e(number_format($item->price, 2)); ?></td>
                                    <td><?php echo e(number_format($item->item_quantity * $item->price, 2)); ?></td>
                                  </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </tbody>
                            </table>
                          </div>
                        </div>
                       
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
        
          </div>
          
        </div>
        <!-- content-wrapper ends -->
        <!-- partial:../../partials/_footer.html -->
       
        <!-- partial -->
        
      
     
      <script>
$( document ).ready(function() {


  $(document).on('click', '.edit', function() {
            var id = $(this).data('id');
            

            var url = '/edit_expenses_data?id=' + id;
            window.location.href = url;
        });

  $('#imageModal').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget); // Button that triggered the modal
        var imageUrl = button.data('bs-image'); // Extract info from data-bs-image attribute
        var modalImage = $('#modalImage'); // Find the image element in the modal
        modalImage.attr('src', imageUrl); // Update the src attribute of the modal image
    });

  var now = new Date();
        var year = now.getFullYear();
        var month = ('0' + (now.getMonth() + 1)).slice(-2); // Months are zero based
        var day = ('0' + now.getDate()).slice(-2);
        var hours = ('0' + now.getHours()).slice(-2);
        var minutes = ('0' + now.getMinutes()).slice(-2);

        $('#date').val(year + '-' + month + '-' + day);
        $('#time').val(hours + ':' + minutes);
    $("#fileUpload").fileUpload();

    new lc_select(document.querySelector('#Category'), {
        wrap_width: '100%',
        min_for_search: 2,
        pre_placeh_opt: true,
    });
    new lc_select(document.querySelector('#subCategory'), {
        wrap_width: '100%',
        min_for_search: 2,
        pre_placeh_opt: true,
    });
    new lc_select(document.querySelector('#branch'), {
        wrap_width: '100%',
        min_for_search: 2,
        pre_placeh_opt: true,
    });
    

    $(document).on('change','#Category', function(){
      
            var id = $('#Category').val();
 
            $.ajax({
                url: "<?php echo e(route('get-expenses-sub-categories')); ?>",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'POST',
                data: {'id':id},
            
                success: function(data) {
                 // Assuming data.data is an array of { id, name } for sub-categories
                    $('#subCategory').empty();  // Clear existing options
                    $('#subCategory').append('<option value="">Select Sub Category</option>');
                    $.each(data.data, function(index, subCategory) {
                    $('#subCategory').append('<option value="' + subCategory.id + '">' + subCategory.expenses_sub_category + '</option>');
                });
            },
                error: function(xhr, textStatus, errorThrown) {
                    alert('Form submission failed!');
                }
            });
        })
  // alert("hi")

  // $(document).on('click','#submit', function(e){
  //   e.preventDefault();
  //   var expensesImages = $('input[name="expensesImages[]"]').prop('files');
  //   if (expensesImages.length > 0) {
  //       // Iterate over the FileList and alert each file name
  //       for (var i = 0; i < expensesImages.length; i++) {
  //           alert(expensesImages[i].name);
  //       }
  //   } else {
  //       alert("No files selected.");
  //   }
  // })

  $(document).on("click", "#submit", function (e) {
        e.preventDefault();
        var fileUploadDiv = $(".file-container"); // Assuming there's only one file upload container
        var fileList = fileUploadDiv.data("fileList") || [];
        var title =$('#title').val();
        var description =$('#description').val();
        var branch =$('#branch').val();
        var date =$('#date').val();
        var time =$('#time').val();
        var Category =$('#Category').val();
        var subCategory =$('#subCategory').val();
        var amount =$('#amount').val();

        var isValid = true;
            var errorMessage = '';

            // Perform individual validation checks for each input field
        if (!date || date.length === 0) {
            errorMessage += 'Date is required.<br>';
            isValid = false;
        }
        if (!Category || Category.length === 0) {
            errorMessage += 'Category is required.<br>';
            isValid = false;
        }
        if (!subCategory || subCategory.length === 0) {
            errorMessage += 'Sub Category is required.<br>';
            isValid = false;
        }
        if (!amount || amount.length === 0) {
            errorMessage += 'Amount is required.<br>';
            isValid = false;
        }
        if (!branch || branch.length === 0) {
            errorMessage += 'Branch is required.<br>';
            isValid = false;
        }
        if (!isValid) {
                Swal.fire({
                    icon: 'error',
                    title: 'Validation Error',
                    html: errorMessage,
                    showCloseButton: true,
                    showCancelButton: false,
                    focusConfirm: false,
                    confirmButtonText: 'OK',
                });
                return;
      }else{
        var form_data = new FormData();
            form_data.append('_token', '<?php echo e(csrf_token()); ?>');
            form_data.append('branchId', branch);
            form_data.append('title', title);
            form_data.append('date', date);
            form_data.append('time', time);
            form_data.append('amount', amount);
            form_data.append('Category', Category);
            form_data.append('subCategory', subCategory);
            form_data.append('description', description);

            $.each(fileList, function (i, file) {
                form_data.append('expensesImages[]', file);
            });

            $.ajax({
                url: '/store-expenses', // Replace with your backend URL
                type: 'POST',
                data: form_data,
                contentType: false,
                processData: false,
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: 'Your data has been submitted successfully!',
                        confirmButtonText: 'OK',
                    }).then((result) => {
                      if (result.isConfirmed) {
                         window.location.reload();
                      }
                    });
                },
                error: function (response) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'There was an error submitting your data.',
                        confirmButtonText: 'OK',
                    });
                }
            });
      }
              
    });
  


  $('#example').DataTable({
            dom: "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            processing: true,
            info: true,
            responsive: true,
            lengthMenu: [
                [10, 25, 50, 100, 200, -1],
                [10, 25, 50, 100, 200, "All"]
            ],


           
            createdRow: function(row, data, dataIndex) {
            // Example condition to change font color
            // Adjust condition as needed
                $(row).css('font-size', '15px');
           
        }
        });
});
      
      </script>
<?php $__env->stopSection(); ?>
      <!-- main-panel ends -->
    
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\USER\Desktop\laravel Chat\Sunsmart pety cash\susmart\resources\views/Section/Expenses/expensesData.blade.php ENDPATH**/ ?>